-- What properties did we think were also owned by the owner of property 7797?
-- Valid-time current and transaction-time sequenced
SELECT P2.property_number, GREATEST( P1.TT_Start, P2.TT_Start ) AS Recorded_Start,
       LEAST( P1.TT_Stop, P2.TT_Stop ) AS Recorded_Stop
FROM Prop_Owner P1, Prop_Owner P2
WHERE P1.property_number = 7797
  AND P2.property_number <> P1.property_number
  AND P1.customer_number = P2.customer_number
  AND P1.VT_Begin <= SYSDATE AND SYSDATE < P1.VT_End
  AND P2.VT_Begin <= SYSDATE AND SYSDATE < P2.VT_End
  AND P1.TT_Start < P2.TT_Stop AND P2.TT_Start < P1.TT_Stop;
