-- Perform a three way join between the Property, Prop_Owner, and Customer
-- bitemporal tables in this current/current query:
-- Who owns the property at Bygaden 4?
SELECT name
FROM Prop_Owner PO, Customer C, Property P
WHERE P.address = 'Bygaden 4'
  AND P.property_number = PO.property_number
  AND C.customer_number = PO.customer_number
  AND PO.VT_Begin <= SYSDATE AND SYSDATE < PO.VT_End
  AND PO.TT_Stop = TO_DATE( '12/31/9999', 'MM/DD/YYYY' )
  AND C.VT_Begin <= SYSDATE AND SYSDATE < C.VT_End
  AND C.TT_Stop = TO_DATE( '12/31/9999', 'MM/DD/YYYY' )
  AND P.VT_Begin <= SYSDATE AND SYSDATE < P.VT_End
  AND P.TT_Stop = TO_DATE( '12/31/9999', 'MM/DD/YYYY' );
