-- Perform a sequenced join between Property, Customer and Prop_Owner in the query:
-- Who has owned the property at Bygaden 4?
SELECT name, GREATEST( PO.VT_Begin, C.VT_Begin, P.VT_Begin ) AS VT_Begin,
       LEAST( PO.VT_End, C.VT_End, P.VT_End ) AS VT_End
FROM Prop_Owner PO, Customer C, Property P
WHERE P.address = 'Bygaden 4'
  AND P.property_number = PO.property_number
  AND C.customer_number = PO.customer_number
  AND GREATEST( PO.VT_Begin, C.VT_Begin, P.VT_Begin ) <
      LEAST( PO.VT_End, C.VT_End, P.VT_End )
  AND PO.TT_Stop = TO_DATE( '12/31/9999', 'MM/DD/YYYY' )
  AND C.TT_Stop = TO_DATE( '12/31/9999', 'MM/DD/YYYY' )
  AND P.TT_Stop = TO_DATE( '12/31/9999', 'MM/DD/YYYY' );
