#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sqlenv.h>

EXEC SQL INCLUDE SQLCA;

int compareDate(char* d1, char* d2, int interval);
int getTime(char* time1, char* time2);

int main(int argc, char** argv) {
  EXEC SQL BEGIN DECLARE SECTION;
    long count, i= 2;
    char eid[12], mid[12], seid[12], smid[12];
    double salary, ssalary;
    char startDate[11], sStartDate[11];
    char endDate[11], sEndDate[11], pEndDate[11];
    char lasttime[9], curtime[9];
  EXEC SQL END DECLARE SECTION;

  EXEC SQL CONNECT TO cs560;

  /* table need to be created before the execution of this program 
     because it is not allowed to insert 
  EXEC SQL CREATE TABLE emp10res (EID char(11),  MID char(11), 
     Salary Decimal(7,2), StartDate date, EndDate date); */

  EXEC SQL VALUES (CURRENT TIME) INTO :lasttime;

  EXEC SQL SELECT COUNT(*) INTO :count FROM emp10;
  EXEC SQL DECLARE ccur CURSOR FOR                 
    select EID, MID, Salary, StartDate, EndDate    
    from emp10                                       
    order by EID, MID, Salary, StartDate, EndDate  
    for read only;                                 

  EXEC SQL OPEN ccur;

  /*  EXEC SQL VALUES (CURRENT TIME) INTO :curtime;
      printf("The sorting time is %d seconds\n", 
      getTime(lasttime, curtime)); */

  /* assuming at least two tuples */
  EXEC SQL FETCH ccur
      into :seid, :smid, :ssalary, :sStartDate, :sEndDate;
  EXEC SQL FETCH ccur
      into :eid, :mid, :salary, :startDate, :endDate;



  strcpy(pEndDate, sEndDate);
  while (1) {
    if ( strcmp(seid, eid) != 0 || strcmp(smid, mid) != 0 ||
	 ssalary != salary || compareDate(pEndDate, startDate, 1) < 0) {
      EXEC SQL INSERT INTO empRes values (:seid, :smid,
	  :ssalary, :sStartDate, :pEndDate); 
      strcpy(seid, eid);
      strcpy(smid, mid);
      ssalary = salary;
      strcpy(sStartDate, startDate);
      strcpy(sEndDate, endDate);
      strcpy(pEndDate, endDate);
    }      
    if ( compareDate(pEndDate, endDate, 0) < 0)
       strcpy(pEndDate, endDate); 

    if ( ++i <= count) 
      EXEC SQL FETCH ccur
	into :eid, :mid, :salary, :startDate, :endDate;
    else
      break;
  }
  EXEC SQL INSERT INTO empRes values (:seid, :smid,
     :ssalary, :sStartDate, :pEndDate); 
      
  EXEC SQL CLOSE ccur;
  EXEC SQL COMMIT;
  EXEC SQL VALUES (CURRENT TIME) INTO :curtime;
  printf("The coalescing time is %d seconds\n", 
	 getTime(lasttime, curtime));
  EXEC SQL CONNECT RESET;
  return 0;
}

int compareDate(char* d1, char* d2, int interval) {
  int month1, date1, year1;
  int month2, date2, year2;

  sscanf(d1, "%d/%d/%d", &month1, &date1, &year1);
  sscanf(d2, "%d/%d/%d", &month2, &date2, &year2);

  date1 += interval;
  if ( year1 < year2)
    return -1;
  if ( year1 > year2)
    return 1;
  if ( month1 < month2)
    return -1;
  if ( month1 > month2)
    return 1;
  if ( date1 < date2)
    return -1;
  if ( date1 > date2)
    return 1;
  return 0;
}

int getTime(char* time1, char* time2) {
  int hour1, min1, sec1;
  int hour2, min2, sec2;

  sscanf(time1, "%d:%d:%d", &hour1, &min1, &sec1);
  sscanf(time2, "%d:%d:%d", &hour2, &min2, &sec2);
  
  return (hour2*3600+min2*60+sec2 - hour1*3600-min1*60-sec1);
}
