/*****************************************************************
 Author: Li Jie
 Date:   Dec. 4, 1997

 The original data set is located at 
 /home/cs460/public_html/TDB/load directory. Those *.ctl files are
 what we needed for performance measurement.

 compile command: gcc -o Format format.c
 Usage: Format sourceFile destFile
 ****************************************************************/

#include <stdio.h>
#include <string.h>

main(int argc, char** argv) {
  FILE *srcfp, *destfp;
  char line[160], fname[60], *p;
  int ieid, imid;
  float salary;
  int year1, month1, date1;
  int year2, month2, date2;
  char smonth1[3], smonth2[3];
  char sdate1[3], sdate2[3];
  char s[160];
    
  if ( argc != 3) {
    fprintf(stderr, "Usage: Format srcfile destfile\n");
    exit(1);
  }
  
  sprintf(fname, "/home/cs460/public_html/TDB/load/%s", argv[1]);
  srcfp = fopen(fname, "r");
  destfp = fopen(argv[2], "w");
  if ( srcfp== NULL || destfp== NULL) {
    fprintf(stderr, "Cannot open file\n");
    exit(1);
  }
  while ( fgets(line, 160, srcfp)) {
    sscanf(line, "%s", s);
    if ( strcmp(s, "BEGINDATA")==0) 
      break;
  }
  while ( fgets(line, 160, srcfp)) {
    if ( strcmp(line, "\n")==0) 
      continue;
    p = line;
    sscanf(p, "%d", &ieid);
    while ( *p != ',') p++;
    p++;
    sscanf(p, "%d", &imid);
    while ( *p != ',') p++;
    p++;
    sscanf(p, "%f", &salary);
    while ( *p != ',') p++;
    p++;
    sscanf(p,"%d/%d/%d",  &date1, &month1, &year1);
    while ( *p != ',') p++;
    p++;
    sscanf(p,"%d/%d/%d",  &date2, &month2, &year2);
    if ( month1< 10)  sprintf(smonth1, "0%d", month1);
    else sprintf(smonth1, "%d", month1);
    if ( month2< 10)  sprintf(smonth2, "0%d", month2);
    else sprintf(smonth2, "%d", month2);

    if ( date1< 10)  sprintf(sdate1, "0%d", date1);
    else sprintf(sdate1, "%d", date1);
    if ( date2< 10)  sprintf(sdate2, "0%d", date2);
    else sprintf(sdate2, "%d", date2);


    fprintf(destfp, "\"%d\",\"%d\",%f,\"%d-%s-%s\",\"%d-%s-%s\"\n",
	    ieid, imid, salary, 1900+year1, smonth1, sdate1, 
	    1900+year2, smonth2, sdate2);
  }
  close(srcfp);
  close(destfp);

}
