/*****************************************************************
 Author: Li Jie
 Date:   Dec. 4, 1997

 Use to modify 2000.dat 4000.dat 10000.dat so that each employee 
 will have exactly 5 segments.

 compile command: gcc -o Modify modify.c
 Usage: Modify tbe_size
 ****************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

main(int argc, char** argv) {
  FILE *fp, *destfp;
  char *num, line[160], *p, filename[20], destfname[20];
  int i, eid;
  int size;

  if ( argc != 2) {
    fprintf(stderr, "Usage: Modify tbl_size\n");
    exit(1);
  }

  size = atoi(argv[1])+1;
  sprintf(filename, "%d.dat", size-1);
  sprintf(destfname, "%dm.dat", size-1);
  fp = fopen(filename, "r");
  destfp = fopen(destfname, "w");
  if ( fp == NULL || destfp == NULL ) { 
    fprintf(stderr, "Cannot open file\n");
    exit(1);
  }

  num = (char*) malloc(sizeof(char)*size);
  memset(num, 0, size);
  while(fgets(line, 160, fp)) {
    p = line+1;
    sscanf(p, "%d", &eid);
    num[eid]++;
    if ( num[eid] <= 5 ) 
      fprintf(destfp, "%s", line);
  }
  /*  for ( i= 0; i< size; i++) 
    printf("%d  ", num[i]);*/
  fclose(fp);
  fclose(destfp);
}  
