-- -----------------------------------------------
-- USING SQL TO DEVELOP TIME ORIENTED APPLICATIONS
-- By : Richard T. Snodgrass
-- -----------------------------------------------
--
-- Current Referential Integrity
-- Only POSITIONS table is temporal
-- By   : Bruce C. Huang
-- Date : Dec. 12, 1997
--
-- There can only be 1 UPDATE/INSERT trigger for
-- table INCUMBENTS.
-- -----------------------------------------------
REM
REM Code Fragment 5.17 in Oracle 7.3
REM There is no ASSERTIONS in Oracle 7.3, only Triggers.
REM
CREATE OR REPLACE TRIGGER cur_ref_integrity
AFTER INSERT or UPDATE on INCUMBENTS
DECLARE 
   valid             INTEGER;
BEGIN
   SELECT 1
   INTO   valid
   FROM   DUAL
   WHERE  EXISTS( SELECT *
                  FROM   INCUMBENTS I
                  WHERE  NOT EXISTS( SELECT *
                                     FROM  POSITIONS P
                                      WHERE I.PCN = P.PCN
                                        AND P.END_DATE = TO_DATE('3000-01-01','YYYY-MM-DD')));

  -- If this SELECT succeeds w/o raising the NO_DATA_FOUND exception,
  --   then this insert/update ensures that the INCUMBENT PCN is
  --   current with the POSITIONS table.

  EXCEPTION
     WHEN NO_DATA_FOUND THEN
        RAISE_APPLICATION_ERROR ( -20001 , 
                                  'Current Position Referential Integrity Violated' );
        -- Abort the offending transaction, and
        --    rollback to a consistent state.

END;
/
