/******************************************************************************/
/* Module:      sqlmsg.pl                                                     */
/* Project:     Oracle Emulator                                               */
/* Author:      Michael Boehlen                                               */
/* Language:    SWI Prolog 2.1.9                                              */
/* Machine:     SPARC/Solaris                                                 */
/* Export:                                                                    */
/*              msg/1 (eval.pl,oracle.pl)                                     */
/*              error/1 (parser.pl,norm_check.pl,eval.pl)                     */
/* Import:                                                                    */
/*              u_expr/3 (parser.pl)                                          */
/******************************************************************************/

/******************************************************************************/
/* Mode:                msg(+MsgId) 	                          	      */
/* Purpose:             prints a message on the screen if verbose mode is on  */
/* Example:             msg(creaTab)					      */
/* Sideeffects:         none                                                  */
/* Call:                exits always                                          */
/* Redo:                fails always                                          */
/******************************************************************************/

msg(M) :- clause(verbose,true) -> affirm_msg(M), nl, nl; true.

affirm_msg(creaTab)      :- write('table created.'). 
affirm_msg(dropTab)      :- write('table dropped.'). 
affirm_msg(creaRec(1))   :- !, format("1 record created.",[]).
affirm_msg(creaRec(Num)) :- format("~d records created.", [Num]).
affirm_msg(delRec(1))    :- !, format("1 record deleted.",[]).
affirm_msg(delRec(Num))  :- format("~d records deleted.", [Num]).
affirm_msg(updRec(1))    :- !, format("1 record updated.", []).
affirm_msg(updRec(Num))  :- format("~d records updated.", [Num]).
affirm_msg(selRec(0))    :- !.
affirm_msg(selRec(1))    :- !, format("1 record selected.", []).
affirm_msg(selRec(Num))  :- format("~d records selected.", [Num]).
affirm_msg(creaVw)       :- write('view created.').
affirm_msg(dropVw)       :- write('view dropped.').
affirm_msg(creaSeq)      :- write('sequence created.').
affirm_msg(dropSeq)      :- write('sequence dropped.').
affirm_msg(rb_done)      :- format("~nrollback completed.~n",[]).
affirm_msg(svp_made)     :- format("~nsavepoint created.~n",[]).
affirm_msg(commit_done)  :- format("~ncommit completed.~n",[]).

/******************************************************************************/
/* Mode:                error(+MsgId) 	                          	      */
/* Purpose:             prints an error message on the screen and fails	      */
/* Example:             error(incTypes_in_setop)			      */
/* Sideeffects:         none                                                  */
/* Call:                fails always 					      */
/******************************************************************************/

error(upd_ambig) :-
  /* ChronoLog/Oracle specific */
  \+clause(verbose,true), !,
  assert(err(-1427)).
error(Msg) :-
  write('***********************************************************'), nl,
  error_msg(Msg,ErrCode), nl,
  write('***********************************************************'), nl, nl,
  assert(err(ErrCode)).

error_msg(exp_for(X,Y),-1):- !,
  format(">>~w<< expected instead of >>~w<<",[X,Y]).
error_msg(incTypes_in_setop,-1):- !,
  write('the TYPES in the select parts of the set operation'), nl,
  write('are not compatible').
error_msg(ill_setop,-1):- !,
  write('the ARITIES of the select parts of the set operation'), nl,
  write('are not equal').
error_msg(obj_ex(O),-1):- !,
  format("there exists already a table/view named >>~w<<",[O]).
error_msg(no_obj(O),-1):- !,
  format("a table/view named >>~w<< does not exist",[O]).
error_msg(meta_obj(O),-1):- !,
  format(">>~w<< is a meta object and may not be changed",[O]).
error_msg(ambig_colN(N),-1):- !,
  format("the column name >>~w<< is ambiguous",[N]).
error_msg(ill_colN(N),-1):- !,
  format("a column named >>~w<< does not exist",[N]).
error_msg(type_err(E,T),-1) :- !,
  u_expr(E,Str,[]),
  format("type error: expression '~s' is not of type '~w'", [Str,T]).
error_msg(unknown_expr(E),-1) :- !,
  format("expression '~w' not recognized during normalization", [E]).
error_msg(upd_ambig,-1427) :- !,
  format("update statement is ambiguous", []).
error_msg(seq_undef(S),-1) :- !,
  format("sequence '~w' is not yet defined in this session", [S]).
error_msg(seq_unknown(S),-1) :- !,
  format("sequence '~w' does not exist", [S]).
error_msg(rbp_unknown,-1) :- !,
  format("this savepoint was never defined", []).
error_msg(ill_cmd,-1) :- !,
  format("illegal (or unimplemented) command", []).
error_msg(T,-1):- 
  format("uncaught error: ~w",[T]).

/******************************************************************************/
/* .									      */
/******************************************************************************/
