#include "core_assoc.h"

IMPLEMENT_DYNAMIC(CAssociate, CObject)

void CAssociate::Erase(){
  Ref<CAssociate> lock = this;
  Ref<CAssociate> p;
  while((const CAssociate *)(p=m_lAssoc.GetAny())){
    Unassociate(this,p);
    if(m_bOwner && !p->m_bOwner) p->Erase();
  }
}

void Associate(CAssociate * a, CAssociate * b){
  a->_AddAssoc(b);
  b->_AddAssoc(a);
}
void Unassociate(CAssociate * a, CAssociate * b){
  a->_RemoveAssoc(b);
  b->_RemoveAssoc(a);
}

CList<CAssociate> & Associates(CAssociate * ar){
  return ar->m_lAssoc;
}
