#ifndef _ASSOC_H_
#define _ASSOC_H_

#include "core_obj.h"
#include "core_dyn.h"
#include "core_list.h"

class CAssociate : public CObject{
  DECLARE_DYNAMIC(CAssociate)
private:
  CList<CAssociate> m_lAssoc;
  bool m_bOwner;
  void _AddAssoc    (CAssociate * pAssoc){ m_lAssoc.Add(pAssoc); }
  bool _RemoveAssoc (CAssociate * pAssoc){ return m_lAssoc.Remove(pAssoc); }
public:
  CAssociate(){
    m_bOwner=false;
  }
  CAssociate(bool b){
    m_bOwner=b;
  }
  virtual void Erase();
  friend void Associate(CAssociate *, CAssociate *);
  friend void Unassociate(CAssociate *, CAssociate *);
  
  friend CList<CAssociate> & Associates(CAssociate * );
};

#define ForEachAssociate(CLASS, NAME, LIST)\
ForEach(CLASS, NAME, CAssociate, Associates(LIST))

#define StrictForEachAssociate(CLASS, NAME, LIST)\
StrictForEach(CLASS, NAME, CAssociate, Associates(LIST))

#endif
