#include "core_dyn.h"

#include <string.h>

CRuntimeClass * g_rLastClass=0;

bool CRuntimeClass::Is(const char * aName){
  return strcmp(aName, m_sClassName)==0;
}

/////////////////////////////////////////////////////
// Global class info

CRuntimeClass * FindClass(const char * aClassName){
  CRuntimeClass * pClass = g_rLastClass;
  while(pClass){
    if(pClass->Is(aClassName)) return pClass;
    pClass = pClass->GetNext();
  }
  return 0;
}

CObject * NewByName(const char * aName) {
  CRuntimeClass * pClass = FindClass(aName);
  if(pClass) return pClass->CreateObject();
  return 0;
}

const CString rootClassName("CObject");

CString GetBaseOf(const char * aClass){
  CRuntimeClass * pClass = FindClass(aClass);
  if(!pClass) return rootClassName;
  else return pClass->GetBaseName();
}

bool KindOf(const char * aClass, const char * aBase){
  if(strcmp(aClass, aBase)==0) return true;
  else if(strcmp(aClass,"CObject")==0) return false;
  else return KindOf(GetBaseOf(aClass), aBase);
}
