#ifndef _EXCEPT_H_
#define _EXCEPT_H_

#define bool short
#define true 1
#define false 0

//////////////////////////////
// Exceptions

class CException {
protected:
  char m_sMessage[1024];
public:
  CException(const char * pMsg1, const char * pMsg2, int i);
  const char * GetMessage() const { return m_sMessage; }  
};

// When using ASSERT(exp) and not __DEBUG__, exp is not evaluated.
#ifdef __DEBUG__ 
#define ASSERT(EXP)\
{ if(!(EXP)) throw CException(#EXP, __FILE__ , __LINE__);}
#define ASSERT_MSG(EXP,MSG)\
{ if(!(EXP)) throw CException(MSG, __FILE__ , __LINE__);}
#else
#define ASSERT(EXP)
#define ASSERT_MSG(EXP,MSG)
#endif

// When using VERIFY(exp), exp is always evaluated.
#define VERIFY(EXP)\
{ if(!(EXP)) throw CException(#EXP, __FILE__ , __LINE__);}
#define VERIFY_MSG(EXP,MSG)\
{ if(!(EXP)) throw CException(MSG, __FILE__ , __LINE__);}

#endif //_EXCEPT_H_
