#ifndef _OBJ_H_
#define _OBJ_H_

#include "core_str.h"

#include <sys/types.h>

class CRuntimeClass;

class CObject{
  // reference counting
private:
  unsigned long m_iCount;
public:
  CObject(){ m_iCount=0;}
  virtual ~CObject() {}
  void _Inc() { m_iCount++; }
  void _Dec() { if(!--m_iCount) delete this; }
  // runtime information
  virtual bool IsKindOf(const char *);
  void* operator new( size_t );
  void  operator delete( void* p );
private:
  virtual CRuntimeClass * GetRuntimeClass();
};

#endif
