#ifndef _REF_H_
#define _REF_H_

#include "core_str.h"
#include "core_obj.h"

template <class TYPE>
class Ref{
private:
  TYPE * m_pObj;
public:
  Ref(void){
    m_pObj=0;
  }
  Ref(TYPE * pObj){
    m_pObj=pObj;
    if(pObj) m_pObj->_Inc();
  }
  Ref(const Ref & rObj){
    m_pObj = rObj.m_pObj;
    if(m_pObj) m_pObj->_Inc();
  }
  ~Ref(){
    if(m_pObj)m_pObj->_Dec();
  }
  Ref & operator = (TYPE * rObj){
    if(m_pObj) m_pObj->_Dec();
    m_pObj = rObj;
    if(m_pObj) m_pObj->_Inc();
    return *this;
  }
  Ref & operator = (Ref & rObj){
    if(m_pObj) m_pObj->_Dec();
    m_pObj = rObj.m_pObj;
    if(m_pObj) m_pObj->_Inc();
    return *this;
  }
  
  TYPE * operator -> () { return m_pObj; }
  operator TYPE * () { return m_pObj; }
  // operator const TYPE * () const { return m_pObj; }
};
#endif

