#include "db.h"

#define VERIFYORA( X ){\
int rc=X;\
char buffer[80];\
if(rc!=0){\
  oermsg(rc,(unsigned char *)buffer);\
  VERIFY_MSG(false, buffer);\
}}

CValue::CValue(int aSize){
  m_iSize = aSize;
  m_pData = new char[m_iSize+1];
  VERIFY_MSG(m_pData, "Memory allocation error.");
}

CValue::~CValue(){
  if(m_pData) delete [] m_pData;
}

CValue & CValue::operator = (const CValue & aValue){
  ASSERT(aValue.m_iSize<=m_iSize);
  m_iSize  = aValue.m_iSize;
  m_irSize = aValue.m_irSize;
  m_sFlags = aValue.m_sFlags;
  m_rCode  = aValue.m_rCode;
  strcpy(m_pData, aValue.m_pData);
  return *this;
}

void CValue::SetData(const char * pData){
  m_irSize=strlen(pData);
  strcpy(m_pData, pData);  
}


///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////

void CRow::Allocate(){
  const CTableDesc * pDesc = GetCursor()->GetDescription();  
  // create a CValue for each column according to the description
  for(int col=0;col<pDesc->m_lTotalColCount;col++){
    const CColDesc * pCol = &(pDesc->m_aCols[col]);
    m_pValue[col] = new CValue(pCol->m_lSize);
  }
}

void CRow::CopyAllDataFrom(const CRow & aRow){
  for(int i=0;i<MAX_COLS;i++){
    if(m_pValue[i] && aRow.m_pValue[i])
      (*m_pValue[i]) = (*aRow.m_pValue[i]);
  }
  m_tVS=aRow.m_tVS;
  m_tVE=aRow.m_tVE;
  m_tTS=aRow.m_tTS;
  m_tTE=aRow.m_tTE;
}

bool CRow::Fetch(){
  // fetch the next row
  const CTableDesc * pDesc = GetCursor()->GetDescription();
  // Bind data values..
  for(int col=0;col<pDesc->m_lTotalColCount;col++){
    const CColDesc * pCol = &(pDesc->m_aCols[col]);
    if(m_pValue[col]){
      CValue   * pVal = m_pValue[col];
      VERIFYORA(odefin(&m_pCursor->m_cda, col+1,
		       (unsigned char *)pVal->GetData(),
		       pCol->m_lSize, 5, -1,
		       & pVal->m_sFlags, (text*)-1,
		       -1, -1, & pVal->m_irSize,
		       (ub2*) & pVal->m_rCode
		       ));
    }
  }
  
  if(ofetch( & m_pCursor->m_cda)==0){
    // insert '\0's in the results
    for(int col=0;col<pDesc->m_lTotalColCount;col++){
      CValue * pVal = m_pValue[col];
      ASSERT_MSG(pVal,"Not enough storage allocated.");
      pVal->GetData()[pVal->m_irSize]='\0';
      pVal->SetNull(pVal->m_sFlags==NULL_VALUE_RET);
    }
    // insert the time values CTime objects
    if(GetCursor()->HasVt()){
      int indexVS = GetCursor()->GetDescription()->m_lVtSIndex;
      int indexVE = GetCursor()->GetDescription()->m_lVtEIndex;            
      m_tVS = CTime(m_pValue[indexVS]->GetData(), m_pValue[indexVS]->IsNull() );
      m_tVE = CTime(m_pValue[indexVE]->GetData(), m_pValue[indexVE]->IsNull() );
    }
    if(GetCursor()->HasTt()){
      int indexTS = GetCursor()->GetDescription()->m_lTtSIndex;
      int indexTE = GetCursor()->GetDescription()->m_lTtEIndex;            
      m_tTS = CTime(m_pValue[indexTS]->GetData(), m_pValue[indexTS]->IsNull() );
      m_tTE = CTime(m_pValue[indexTE]->GetData(), m_pValue[indexTE]->IsNull() );
    }        
    return true;
  } else {
    if(m_pCursor->m_cda.rc!=NO_DATA_FOUND)
      VERIFYORA(m_pCursor->m_cda.rc);
    return false;
  }
}

CRow::CRow(CCursor * pCursor) : m_pCursor(pCursor) {
  for(int i=0;i<MAX_COLS;i++) m_pValue[i]=NULL;
  m_lInsertionCursorCount=0;
  ASSERT_MSG(m_pCursor, "CRow::CRow : Contruct from invalid cursor pointer.");
  ASSERT_MSG(!m_pCursor->DoesInsertion(), "CRow::CRow : Contruct from insertion cursor.");
  ASSERT_MSG(m_pCursor->IsSelect(), "CRow::CRow : Only select queries.");
  m_pCursor->RowCreated();
  Allocate();
}

CRow::~CRow(){
  m_pCursor->RowDeleted();
  ASSERT_MSG(m_lInsertionCursorCount<=0, 
	     "CRow::~CRow : All insertion cursors *must* be deleted first.");
  for(int i=0;i<MAX_COLS;i++){
    if(m_pValue[i]){ delete m_pValue[i]; m_pValue[i]=NULL; }
  }
}

void CRow::SetVtStart(CTime t)
{
  const CTableDesc * pDesc = GetCursor()->GetDescription();
  int ind=pDesc->m_lVtSIndex;
  if(ind>=0){
    CValue * pVal=m_pValue[ind];
    m_tVS=t;
    if(t.IsNow()){
      pVal->SetData("");
      pVal->SetNull(true);
    } else { 
      pVal->SetNull(false);
      pVal->SetData(t.AsString());
    }
  }  
}

void CRow::SetVtEnd  (CTime t)
{
  const CTableDesc * pDesc = GetCursor()->GetDescription();
  int ind=pDesc->m_lVtEIndex;
  if(ind>=0){
    CValue * pVal=m_pValue[ind];
    m_tVE=t;
    if(t.IsNow()){
      pVal->SetData("");
      pVal->SetNull(true);
    } else { 
      pVal->SetNull(false);
      pVal->SetData(t.AsString());
    }
  }  
}

void CRow::SetTtStart(CTime t)
{
  const CTableDesc * pDesc = GetCursor()->GetDescription();
  int ind=pDesc->m_lTtSIndex;
  if(ind>=0){
    CValue * pVal=m_pValue[ind];
    m_tTS=t;
    if(t.IsNow()){
      pVal->SetData("");
      pVal->SetNull(true);
    } else { 
      pVal->SetNull(false);
      pVal->SetData(t.AsString());
    }
  }  
}

void CRow::SetTtEnd  (CTime t)
{
  const CTableDesc * pDesc = GetCursor()->GetDescription();
  int ind=pDesc->m_lTtEIndex;
  if(ind>=0){
    CValue * pVal=m_pValue[ind];
    m_tTE=t;
    if(t.IsNow()){
      pVal->SetData("");
      pVal->SetNull(true);
    } else { 
      pVal->SetNull(false);
      pVal->SetData(t.AsString());
    }
  }  
}

///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
CString CCursor::GetOrderedQuery(CString tableName){
  char buffer[80];
  int i;
  const CTableDesc * desc = GetDescription();
  
  int d=1;
  CString names;
  CString order;

  bool first=true;
  for(i=0;i<desc->m_lTotalColCount;i++){
    if(!IsTime(i)){
      if(!first){
     	names+=CString(",");
	order+=CString(",");
      } else first=false;
      names+=desc->m_aCols[i].m_sName;
      order+=CString((long)d++);
    } 
  }  
  if(HasVt()){
    if(!first){
      names+=CString(",");
      order+=CString(",");
    } else first=false;
    names+=CString(VTSNAME)+","+CString(VTENAME);
    order+=CString((long)d++)+","+CString((long)d++);
  }
  if(HasTt()){
    if(!first){
      names+=CString(",");
      order+=CString(",");
    } else first=false;
    names+=CString(TTSNAME)+","+CString(TTENAME);
    order+=CString((long)d++)+","+CString((long)d++);
  }
  // at least one col in table, so now first==false!
  ASSERT(first==false);

  CString result=CString("SELECT ")+names+CString(" FROM ")+
    tableName+CString(" ORDER BY ")+order;
  // printf("USING: '%s'\n",(const char *)result);
  return result;
}

CString CCursor::CreateInsertionQuery(const char * tName){
  CString names;
  CString values;
  const CTableDesc * desc = GetDescription();
  char buffer[80];

  bool first=true;
  for(int i=0;i<desc->m_lTotalColCount;i++){
    if(!first){
      values +=CString(", ");
      names  +=CString(", ");
    } else first=false;
    sprintf(buffer,":V%d",i);
    values+=buffer;
    names+=desc->m_aCols[i].m_sName;       
  } 
  // insert into <table> (<names>) values (<values>)
  CString insert = CString("INSERT INTO ")+CString(tName)+
    CString("(")+names+CString(") values (")+values+CString(")");
  return insert;
  //VERIFY_MSG(0,"UNIMPLEMENTED");
}



// static variable initialisation,
// purpose: keep state of verbose on C++ engine
int CCursor::verbose = 0;


void CCursor::Parse(const char * aQuery){
  if (verbose == 1) printf("!!%s\n",aQuery); 
  VERIFY_MSG(0==oparse(&m_cda, (text*) aQuery, (sb4)-1, 
		       (sword) PARSE_NO_DEFER, (ub4)PARSE_V7_LNG),
	     "CCursor::Parse : Unable to parse statement.");
}

struct tempData {
  sb2   dbtype, scale;
  sb4   dbsize, dsize;
  char  colName[MAX_COLNAME_SIZE+1];
  sb4   nameLength;
};

void CCursor::Describe(){
  CTableDesc * pDesc = GetDescription();
  pDesc->m_lTotalColCount=0;
  pDesc->m_lVtSIndex     =-1;
  pDesc->m_lVtEIndex     =-1;
  pDesc->m_lTtSIndex     =-1;
  pDesc->m_lTtEIndex     =-1;
  
  tempData t;
  t.nameLength = MAX_COLNAME_SIZE;
  int col=0;
  
  while(0==odescr( &m_cda, col+1, &t.dbsize, &t.dbtype, (sb1*) t.colName, 
		   & t.nameLength, & t.dsize, (sb2*) 0, &t.scale, (sb2*)0)){
    t.colName[t.nameLength]='\0'; 
    // Identify time cols...
    if       (strcmp(VTSNAME, t.colName)==0){     
      pDesc->m_lVtSIndex=col;
    } else if(strcmp(VTENAME, t.colName)==0){
      pDesc->m_lVtEIndex=col;
    } else if(strcmp(TTSNAME, t.colName)==0){
      pDesc->m_lTtSIndex=col;
    } else if(strcmp(TTENAME, t.colName)==0){
      pDesc->m_lTtEIndex=col;
    } 
    // Fot all columns store information about it.
    CColDesc * pCol = & (pDesc->m_aCols[col]);
    // copy type
    pCol->m_sType = t.dbtype;
    // copy size
    pCol->m_lSize = t.dsize;
    // copy name
    strcpy(pCol->m_sName, t.colName);

    col++;
    pDesc->m_lTotalColCount = col;
    t.nameLength = MAX_COLNAME_SIZE;
  } 
  VERIFY(m_cda.rc==SELECT_COL_END);  
}

void CCursor::Execute(){
  VERIFYORA(oexec(&m_cda));
}

// for fetching
CCursor::CCursor(CSession * pSession, const CString & aQuery) : m_pSession(pSession) {
  ASSERT_MSG(m_pSession, "CCursor::CCursor : Contruct from invalid session pointer.");
  m_pInsertionRow = NULL;
  m_lRowCount=0;
  VERIFY(0==oopen( &m_cda, m_pSession->m_pLda, NULL, -1, 0, NULL, 0));
  
  // Parse the query
  Parse(aQuery);  
  if(IsSelect()) Describe();
  m_pSession->CursorCreated();
}

// for insertion
CCursor::CCursor(CSession * pSession, const char * tableName, CRow * pRow) : 
  m_pSession(pSession), m_pInsertionRow(pRow) 
{
  ASSERT_MSG(m_pSession, "CCursor::CCursor : Contruct from invalid session pointer.");
  ASSERT_MSG(m_pInsertionRow, "CCursor::CCursor : Contruct from invalid row pointer.");
  m_lRowCount=0;
  VERIFY(0==oopen( &m_cda, m_pSession->m_pLda, NULL, -1, 0, NULL, 0));

  // Contruct a query
  // CString aQuery = "insert into a values ('trask')";
  CString aQuery=pRow->GetCursor()->CreateInsertionQuery(tableName);

  // Parse the query
  Parse(aQuery);
  VERIFY_MSG(m_cda.ft==FT_INSERT, "CCursor::CCursor : Must be an insert query.");

  // Get info on table
  Describe();

  // Check that the tables have the same format  
  // VERIFY_MSG(CombatibleTables(this, m_pInsertionRow->GetCursor()), 
  // "CCursor::CCursor : Construct from incombatible rowd");
  char buffer[80];
  bool first=true;
  CTableDesc * pDesc=m_pInsertionRow->GetCursor()->GetDescription();
  for(int col=0;col<pDesc->m_lTotalColCount;col++){
    const CColDesc * pCol = &(pDesc->m_aCols[col]);
    CValue   * pVal = m_pInsertionRow->m_pValue[col];
    if(pVal){
      sprintf(buffer,":V%d",col);
      VERIFY(0==obndrv(&m_cda, (unsigned char *)buffer , -1, (unsigned char *)pVal->GetData(),
		       pCol->m_lSize, 5, -1, (sb2*)0, 0, -1, -1));
    }
  }
  m_pInsertionRow->CursorCreated();
  m_pSession->CursorCreated();
}

CCursor::~CCursor(){
  ASSERT_MSG(m_lRowCount==0, "CCursor::~CCursor : All rows must be deleted first.");
  m_pSession->CursorDeleted();
  if(m_pInsertionRow) {
    m_pInsertionRow->CursorDeleted();
    m_pInsertionRow=NULL;
  }
  oclose(&m_cda);
}

///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////

CSession::CSession(){
  Init();
}  

CSession::~CSession(){
  ASSERT_MSG(m_lCursorCount==0, "CSession::~CSession : All cursors *must* be deleted first.");
  if(m_bConnected && m_bOwner){
    ologof(m_pLda);
    delete m_pLda;
  }
}

void CSession::PrintError(int aCode){
  char buffer[1024];
  oerhms(m_pLda, aCode, (text *) buffer, 1024);
  printf("Error: %s\n", buffer);
}

void CSession::Init(){
  m_lCursorCount = 0;
  m_pLda        = NULL;
  m_bConnected  = false;
  m_bOwner      = false;
}

void CSession::Open(const char * aUserName){
  ASSERT(m_pLda==0);
  m_pLda = new Lda_Def;
  olon(m_pLda, (text*)aUserName, (sword)-1, (text*)0, (sword)-1, OCI_LM_DEF);
  // success??
  ASSERT_MSG(m_pLda->rc==0,"CSession::Open - Unable to connect to oracle");
    m_bConnected = true;
  m_bOwner     = true;
}

void CSession::Open(Lda_Def * pDef){
  ASSERT_MSG(m_pLda==0, "CSession::Open - Already open?");
  ASSERT_MSG(pDef!=0, "CSession::Open - Illegal Lda_Def?");
  m_pLda       = pDef;
  m_bConnected = true;
  m_bOwner     = false;
}
