#ifndef _MODULE_H_
#define _MODULE_H_

#include "core.h"
#include "mod.h"
#include "db.h"

//////////////////////////////////////////////////
// Constructor/destructor
int    InitModules();
void   CloseModules();

//////////////////////////////////////////////////
// Helper functions
CString CreateTempTableFrom(CSession * pSession, CString aQuery);
void    GetSysDate(CSession * pSession);
int     GetTempNum(CSession * pSession);

//////////////////////////////////////////////////
// Coalescing
CString Coal_temp_vt(CSession * pSession, const CString & aQuery);
CString Coal_temp_tt(CSession * pSession, const CString & aQuery);
CString Coal_bitemp_vt(CSession * pSession, const CString & aQuery);
CString Coal_bitemp_tt(CSession * pSession, const CString & aQuery);

//////////////////////////////////////////////////
// Difference
CString Difference_temp_vt(CSession * pSession, const CString & , const CString & );
CString Difference_temp_tt(CSession * pSession, const CString & , const CString & );
CString Difference_bitemp(CSession * pSession, const CString & , const CString & );

//////////////////////////////////////////////////
// Aggregation

CString Aggregate_bi_count(CSession *, const CString &, const CString &, const CString &);

#endif //_MODULE_H_





