#include "core.h"
#include "mod.h"
#include "db.h"
#include "lib.h"

#include <stdio.h>

///////////////////////////////////////////////////////////////////////////////
//
// Coalescing of vt of a bitemporal table.
//
//

CString Coal_bitemp_vt(CSession * pSession, const CString & aQuery){    
  CString tempName;
  //////////////////////////////
  // Parse the query  
  CCursor c0(pSession,aQuery);
  VERIFY_MSG(c0.HasVt(),"Coal_bitemp_vt: Table must have VT.");
  VERIFY_MSG(c0.HasTt(),"Coal_bitemp_vt: Table must have TT.");
  //////////////////////////////
  // Construct a table for the result
  tempName=CreateTempTableFrom(pSession, aQuery);
  //////////////////////////////
  // Getting an ordered query
  CString order = c0.GetOrderedQuery(CString("("+aQuery+")"));
  CCursor c1(pSession,order);
  c1.Execute();  
  //////////////////////////////
  // Perform coalescing
  CRow r1(&c1);
  CRow r2(&c1);  
  Ref<CRectSet> pRects = new CRectSet;
  if(r1.Fetch()){
    CCursor c2(pSession, tempName, &r1);
    Associate(pRects, r1.GetBitemp());
    while(r2.Fetch()){
      if(IdenticalValues(r1,r2)){
	Associate(pRects, r2.GetBitemp());
      } else {
	GeoCoalX(pRects);
	StrictForEachAssociate(CRectangle, r, pRects){
	  r1.SetBitemp(r);
	  c2.Execute();
	}
	pRects->Erase();
	Associate(pRects, r2.GetBitemp());
	r1.CopyAllDataFrom(r2);
      }
    }    
    GeoCoalX(pRects);
    StrictForEachAssociate(CRectangle, r, pRects){
      r1.SetBitemp(r);
      c2.Execute();
    }
    pRects->Erase();
  }  
  //////////////////////////////
  // Return name of temporary
  return tempName;
}

CString Coal_bitemp_tt(CSession * pSession, const CString & aQuery){    
  CString tempName;
  //////////////////////////////
  // For comments, see above
  CCursor c0(pSession, aQuery);
  VERIFY_MSG(c0.HasVt(),"Coal_bitemp_tt: Table must have VT.");
  VERIFY_MSG(c0.HasTt(),"Coal_bitemp_tt: Table must have TT.");
  tempName=CreateTempTableFrom(pSession, aQuery);
  CString order = c0.GetOrderedQuery(CString("("+aQuery+")"));
  CCursor c1(pSession, order);
  c1.Execute();  
  CRow r1(&c1);
  CRow r2(&c1);
  Ref<CRectSet> pRects = new CRectSet;
  if(r1.Fetch()){  
    CCursor c2(pSession, tempName, &r1);    
    Associate(pRects, r1.GetBitemp());
    while(r2.Fetch()){
      if(IdenticalValues(r1,r2)){
	Associate(pRects, r2.GetBitemp());
      } else {
	GeoCoalY(pRects);
	StrictForEachAssociate(CRectangle, r, pRects){
	  r1.SetBitemp(r);
	  c2.Execute();
	}
	pRects->Erase();
	Associate(pRects, r2.GetBitemp());
	r1.CopyAllDataFrom(r2);
      }
    }    
    GeoCoalY(pRects);
    StrictForEachAssociate(CRectangle, r, pRects){
      r1.SetBitemp(r);
      c2.Execute();
    }
    pRects->Erase();
  }
  return tempName;
}

