#include "core.h"
#include "mod.h"
#include "db.h"
#include "lib.h"

#include <stdio.h>

///////////////////////////////////////////////////////////////////////////////
//
// Coalescing of valid time of a temporal table.
//

CString Coal_temp_vt(CSession * pSession, const CString & aQuery){
  CString tempName;
  //////////////////////////////
  // Parse the query  
  CCursor c0(pSession,aQuery);
  VERIFY_MSG(c0.HasVt(), "Coal_temp_vt: Table must have VT.");
  VERIFY_MSG(!c0.HasTt(),"Coal_temp_vt: Table must not have TT.");  
  //////////////////////////////
  // Construct a table for the result
  tempName=CreateTempTableFrom(pSession, aQuery);  
  //////////////////////////////
  // Getting an ordered query
  CString order = c0.GetOrderedQuery(CString("("+aQuery+")"));
  CCursor c1(pSession,order);
  c1.Execute();  
  //////////////////////////////
  // Perform coalescing
  CRow r1(&c1);
  CRow r2(&c1);
  if(r1.Fetch()){  
    // Prepare c2 for insertion into table 'tempName'.
    CCursor c2(pSession,tempName, &r1);    
    // The statement c2.Execute(); now means insert the row 
    // r1 into table tempName
    // Now, do the coalescing....
    while(r2.Fetch()){
      if(IdenticalValues(r1,r2)){
	if( (r1.VtEnd()).IsPointLater(r2.VtStart()) ){
	  r1.SetVtEnd(Max(r1.VtEnd(),r2.VtEnd()));
	} else {
	  c2.Execute();
	  r1.CopyAllDataFrom(r2);
	}
      } else {	
	c2.Execute();
	r1.CopyAllDataFrom(r2);
      }
    }    
    c2.Execute();
  }
  //////////////////////////////
  // Return name of temporary table
  return tempName;
}

CString Coal_temp_tt(CSession * pSession, const CString & aQuery){    
  //////////////////////////////
  // See above for comments
  CCursor c0(pSession,aQuery);
  VERIFY_MSG(!c0.HasVt(),"Coal_temp_tt: Table must not have VT.");
  VERIFY_MSG(c0.HasTt(), "Coal_temp_tt: Table must have TT.");
  CString tempName=CreateTempTableFrom(pSession, aQuery);
  CString order = c0.GetOrderedQuery(CString("("+aQuery+")"));
  CCursor c1(pSession,order);
  c1.Execute();
  CRow r1(&c1);
  CRow r2(&c1);
  if(r1.Fetch()){  
    CCursor c2(pSession,tempName, &r1);    
    while(r2.Fetch()){
      if(IdenticalValues(r1,r2)){
	if( (r1.TtEnd()).IsPointLater(r2.TtStart()) ){
	  r1.SetTtEnd(Max(r1.TtEnd(),r2.TtEnd()));
	} else {
	  c2.Execute();
	  r1.CopyAllDataFrom(r2);
	}
      } else {
	c2.Execute();
	r1.CopyAllDataFrom(r2);
      }
    }    
    c2.Execute();
  }
  return tempName;
}
