#include "core.h"

#include "mod_aggregate.h"
#include "mod_matrix.h"


CSetRef Aggregate(CRectSet * pTable){
  CSetRef res = new CRectSet;
  
  CSetRef rSet = new CRectSet;
  StrictForEachAssociate(CRectangle, r, pTable){
    Associate(r,rSet);
  }
  // Associate overlapping rectangles
  {
    StrictForEachAssociate(CRectangle, a, rSet){
      StrictForEachAssociate(CRectangle, b, rSet){
	if((a!=b) && Overlap(*a, *b)) Associate(a,b);
      }
    }
  }
  // Extend the relation to connected
  {
    StrictForEachAssociate(CRectangle, a, rSet){
      StrictForEachAssociate(CRectangle, b, a){
	StrictForEachAssociate(CRectangle, c, b){
	  if(a!=c) Associate(a,c);
	}
      }
    }
  }
  // Now rSet form a set of complete graphs
  
  CRectRef start;
  while(start = (CRectangle *) Associates(rSet).GetAny()){
    CSetRef rCurrent = new CRectSet;
    Associate(start, rCurrent);
    StrictForEachAssociate(CRectangle, r, start){
      Associate(r, rCurrent);
    }
    StrictForEachAssociate(CRectangle, s, rCurrent){
      Unassociate(s, rSet);
    }
    {
      // We construct the infinite time plane
      CRectRef rInfin = new CRectangle(
        BEGINNING_OF_TIME, BEGINNING_OF_TIME, 
        END_OF_TIME, END_OF_TIME);
      CMatRef mat = new CMatrix;
      mat->Create(rInfin);
      mat->AddRects(rCurrent);
      mat->AssociateColor(res);
      mat->Erase();
    }
  } 
  return res;
}


