#include "core.h"

#include "mod_range.h"
#include "mod_rectangle.h"
#include "mod_coal.h"

void AssociateHOverlaps(CRectSet * pRects){
  StrictForEachAssociate(CRectangle, a, pRects){
    StrictForEachAssociate(CRectangle, b, pRects){
      if(a!=b){
        if(HOverlap(*a,*b)) Associate(a,b);
      }
    }
  }
}

void AssociateVOverlaps(CRectSet * pRects){
  StrictForEachAssociate(CRectangle, a, pRects){
    StrictForEachAssociate(CRectangle, b, pRects){
      if(a!=b){
        if(VOverlap(*a,*b)) Associate(a,b);
      }
    }
  }
}

void CleanAssociates(CRectSet * pRects){
  StrictForEachAssociate(CRectangle, a, pRects){
    StrictForEachAssociate(CRectangle, b, pRects){
      Unassociate(a,b);
    }
  }
}

////////////////
// Can ???

bool CanMergeY(CRectangle * a, CRectangle * b){
  return (a->x1 == b->x1) && (a->x2 == b->x2);
}
bool CanSplit1Y(CRectangle * a, CRectangle * b){
  return (a->x1 < b->x1) && (b->x1 < a->x2);
}
bool CanSplit2Y(CRectangle * a, CRectangle * b){
  return (a->x1 < b->x2) && (b->x2 < a->x2);
}

bool CanMergeX(CRectangle * a, CRectangle * b){
  return (a->y1 == b->y1) && (a->y2 == b->y2);
}
bool CanSplit1X(CRectangle * a, CRectangle * b){
  return (a->y1 < b->y1) && (b->y1 < a->y2);
}
bool CanSplit2X(CRectangle * a, CRectangle * b){
  return (a->y1 < b->y2) && (b->y2 < a->y2);
}


////////////////
// Do !!
void MergeY(CRectSet * rRects, CRectangle * a, CRectangle * b){
  // calculate rect bounds
  CTime x1 = MostSig(a->x1,b->x1);
  CTime x2 = MostSig(a->x2,b->x2);
  CTime y1 = Min(a->y1,b->y1);
  CTime y2 = Max(a->y2,b->y2);
  CRectRef c = new CRectangle(x1,y1,x2,y2);
  // insert the rect
  Associate(rRects, c);
  
  // update associations
  StrictForEachAssociate(CRectangle, x, a)
    if(HOverlap(*x,*c))
      Associate(x,c);
  StrictForEachAssociate(CRectangle, y, b)
    if(HOverlap(*y,*c))
      Associate(y,c);
  
  a->Erase();
  b->Erase();
}
void Split1Y(CRectSet * rRects, CRectangle * a, CRectangle * b){
  // Create the new rectangles
  CRectRef a1 = new CRectangle(a->x1,a->y1,b->x1,a->y2);
  CRectRef a2 = new CRectangle(b->x1,a->y1,a->x2,a->y2);
  Associate(rRects,a1);
  Associate(rRects,a2);
  
  // update associations
  StrictForEachAssociate(CRectangle, x, a){
    if(HOverlap(*x, *a1))
      Associate(x,a1);
    if(HOverlap(*x, *a2))
      Associate(x,a2);
  }
  // Clean up
  a->Erase();
}

void Split2Y(CRectSet * rRects, CRectangle * a, CRectangle * b){
  // Create the new rectangles
  CRectRef a1 = new CRectangle(a->x1,a->y1,b->x2,a->y2);
  CRectRef a2 = new CRectangle(b->x2,a->y1,a->x2,a->y2);
  Associate(rRects,a1);
  Associate(rRects,a2);
  
  // update associations
  StrictForEachAssociate(CRectangle, x, a){
    if(HOverlap(*x, *a1))
      Associate(x,a1);
    if(HOverlap(*x, *a2))
      Associate(x,a2);
  }
  // Clean up
  a->Erase();
}

void SplitY(CRectSet * r, CRectangle * a, CRectangle * b){
  if(CanMergeY(a,b)) MergeY(r,a,b);
  else if(CanSplit1Y(a,b)) Split1Y(r,a,b);
  else if(CanSplit1Y(b,a)) Split1Y(r,b,a);
  else if(CanSplit2Y(a,b)) Split2Y(r,a,b);
  else if(CanSplit2Y(b,a)) Split2Y(r,b,a);
}


void MergeX(CRectSet * rRects, CRectangle * a, CRectangle * b){
  // calculate rect bounds
  CTime x1 = Min(a->x1,b->x1); 
  CTime x2 = Max(a->x2,b->x2);
  CTime y1 = MostSig(a->y1,b->y1);
  CTime y2 = MostSig(a->y2,b->y2);
  CRectRef c = new CRectangle(x1,y1,x2,y2);
  // insert the rect
  Associate(rRects, c);
  
  // update associations
  StrictForEachAssociate(CRectangle, x, a)
    if(VOverlap(*x,*c))
      Associate(x,c);
  StrictForEachAssociate(CRectangle, y, b)
    if(VOverlap(*y,*c))
      Associate(y,c);
  
  a->Erase();
  b->Erase();
}
void Split1X(CRectSet * rRects, CRectangle * a, CRectangle * b){
  // Create the new rectangles
  CRectRef a1 = new CRectangle(a->x1,a->y1,a->x2,b->y1);
  CRectRef a2 = new CRectangle(a->x1,b->y1,a->x2,a->y2);
  Associate(rRects,a1);
  Associate(rRects,a2);
  
  // update associations
  StrictForEachAssociate(CRectangle, x, a){
    if(VOverlap(*x, *a1))
      Associate(x,a1);
    if(VOverlap(*x, *a2))
      Associate(x,a2);
  }
  // Clean up
  a->Erase();
}

void Split2X(CRectSet * rRects, CRectangle * a, CRectangle * b){
  // Create the new rectangles
  CRectRef a1 = new CRectangle(a->x1,a->y1,a->x2,b->y2);
  CRectRef a2 = new CRectangle(a->x1,b->y2,a->x2,a->y2);
  Associate(rRects,a1);
  Associate(rRects,a2);
  
  // update associations
  StrictForEachAssociate(CRectangle, x, a){
    if(VOverlap(*x, *a1))
      Associate(x,a1);
    if(VOverlap(*x, *a2))
      Associate(x,a2);
  }
  // Clean up
  a->Erase();
}

void SplitX(CRectSet * r, CRectangle * a, CRectangle * b){
  if(CanMergeX(a,b)) MergeX(r,a,b);
  else if(CanSplit1X(a,b)) Split1X(r,a,b);
  else if(CanSplit1X(b,a)) Split1X(r,b,a);
  else if(CanSplit2X(a,b)) Split2X(r,a,b);
  else if(CanSplit2X(b,a)) Split2X(r,b,a);
}

void GeoCoalX(CRectSet * pRects){
  CleanAssociates(pRects);
  AssociateHOverlaps(pRects);
  bool change;
  do{
    change=false;
    // find a rectangle (a) that is associated to at least
    // one other rectangle
    StrictForEachAssociate(CRectangle, a, pRects){
      StrictForEachAssociate(CRectangle, b, a){
        if(a!=b){
          SplitY(pRects,a,b);
          change=true;
          break;
        }
      }
      if(change)break;
    }
  } while(change);
}

void GeoCoalY(CRectSet * pRects){
  CleanAssociates(pRects);
  AssociateVOverlaps(pRects);
  bool change;
  do{
    change=false;
    // find a rectangle (a) that is associated to at least
    // one other rectangle
    StrictForEachAssociate(CRectangle, a, pRects){
      StrictForEachAssociate(CRectangle, b, a){
        if(a!=b){
          SplitX(pRects,a,b);
          change=true;
          break;
        }
      }
      if(change)break;
    }
  } while(change);
}

