#ifndef _RANGE_H_
#define _RANGE_H_

#include "core.h"
#include "mod_tim.h"

class CRange : public CAssociate{
  DECLARE_DYNAMIC(CRange)
public:
  CTime t1,t2;
  
  CRange() {};
  CRange(const CTime & ct1, const CTime & ct2){
    t1=ct1; t2=ct2;
  }
};
typedef Ref<CRange> CRanRef;

class CRangeSet : public CAssociate {
	DECLARE_DYNAMIC(CRangeSet)
public:
	// make the rangeset own the associated objects
	CRangeSet() : CAssociate(true){}
};
typedef Ref<CRangeSet> CRSetRef;


inline bool Overlap(const CRange & r1, CRange & r2){
  // returns true if and only if the two CRanges r1 
  // and r2 have a CRange in common
  return
    ((r1.t1<=r2.t1) && (r2.t1<r1.t2))||
    ((r1.t1<r2.t2) && (r2.t2<=r1.t2))||
    ((r2.t1<=r1.t1) && (r1.t1<r2.t2))||
    ((r2.t1<r1.t2) && (r1.t2<=r2.t2));
}

inline bool POverlap(const CRange & r1, CRange & r2){
  // returns true if and only if the two CRanges r1
  // and r2 have at least a point in common
  return
    ((r1.t1<=r2.t1) && (r2.t1<=r1.t2))||
    ((r1.t1<=r2.t2) && (r2.t2<=r1.t2))||
    ((r2.t1<=r1.t1) && (r1.t1<=r2.t2))||
    ((r2.t1<=r1.t2) && (r1.t2<=r2.t2));
}

inline bool In (const CTime & t, const CRange & r){
  return (r.t1<t )&& (t<r.t2);
}

inline bool Pin (const CTime & t, const CRange & r){
  return (r.t1<=t )&& (t<=r.t2);
}
#endif
