#ifndef _RECT_H_
#define _RECT_H_

#include "core.h"

#include "mod_tim.h"
#include "mod_range.h"

class CRectangle : public CAssociate{
  DECLARE_DYNAMIC(CRectangle)
public:
  CTime x1, x2, y1, y2;
  CRectangle() {};
  CRectangle(const CRectangle & r) : 
    x1(r.x1), x2(r.x2), y1(r.y1), y2(r.y2) {}
  CRectangle(const CTime & tx1, const CTime & ty1,
	     const CTime & tx2, const CTime & ty2) : 
    x1(tx1),x2(tx2),y1(ty1),y2(ty2) {}
  
};

typedef Ref<CRectangle> CRectRef;
class CRectSet : public CAssociate {
  DECLARE_DYNAMIC(CRectSet)
public:
  // make the rectset own the associated objects
    CRectSet() : CAssociate(true){}
};
typedef Ref<CRectSet> CSetRef;


inline bool Overlap(const CRectangle & r1, const CRectangle & r2){
  // returns true if and only if the two CRectangles r1 and
  // r2 have a CRectangle in common
  return
    ( 
     ((r1.x1<=r2.x1) && (r2.x1<r1.x2))||
     ((r1.x1<r2.x2) && (r2.x2<=r1.x2))||
     ((r2.x1<=r1.x1) && (r1.x1<r2.x2))||
     ((r2.x1<r1.x2) && (r1.x2<=r2.x2))
     ) && (
	   ((r1.y1<=r2.y1) && (r2.y1<r1.y2))||
	   ((r1.y1<r2.y2) && (r2.y2<=r1.y2))||
	   ((r2.y1<=r1.y1) && (r1.y1<r2.y2))||
	   ((r2.y1<r1.y2) && (r1.y2<=r2.y2))
	   );
}

inline bool HOverlap(const CRectangle & r1, const CRectangle & r2){
  // returns true if and only if the two CRectangles r1 and 
  // r2 have at least a horizontal line in common
  return
    ( 
     ((r1.x1<=r2.x1) && (r2.x1<r1.x2))||
     ((r1.x1<r2.x2) && (r2.x2<=r1.x2))||
     ((r2.x1<=r1.x1) && (r1.x1<r2.x2))||
     ((r2.x1<r1.x2) && (r1.x2<=r2.x2))
     ) && (
	   ((r1.y1<=r2.y1) && (r2.y1<=r1.y2))||
	   ((r1.y1<=r2.y2) && (r2.y2<=r1.y2))||
	   ((r2.y1<=r1.y1) && (r1.y1<=r2.y2))||
	   ((r2.y1<=r1.y2) && (r1.y2<=r2.y2))
	   );
}

inline bool VOverlap(const CRectangle & r1, const CRectangle & r2){
  // returns true if and only if the two CRectangles r1 and 
  // r2 have at least a vertical line in common
  return
    ( 
     ((r1.x1<=r2.x1) && (r2.x1<=r1.x2))||
     ((r1.x1<=r2.x2) && (r2.x2<=r1.x2))||
     ((r2.x1<=r1.x1) && (r1.x1<=r2.x2))||
     ((r2.x1<=r1.x2) && (r1.x2<=r2.x2))
     ) && (
	   ((r1.y1<=r2.y1) && (r2.y1<r1.y2))||
	   ((r1.y1<r2.y2) && (r2.y2<=r1.y2))||
	   ((r2.y1<=r1.y1) && (r1.y1<r2.y2))||
	   ((r2.y1<r1.y2) && (r1.y2<=r2.y2))
	   );
}

inline bool POverlap(const CRectangle & r1, const CRectangle & r2){
  // returns true if and only if the two CRectangles r1 and 
  // r2 have at least a point in common
  return
    ( 
     ((r1.x1<=r2.x1) && (r2.x1<=r1.x2))||
     ((r1.x1<=r2.x2) && (r2.x2<=r1.x2))||
     ((r2.x1<=r1.x1) && (r1.x1<=r2.x2))||
     ((r2.x1<=r1.x2) && (r1.x2<=r2.x2))
     ) && (
	   ((r1.y1<=r2.y1) && (r2.y1<=r1.y2))||
	   ((r1.y1<=r2.y2) && (r2.y2<=r1.y2))||
	   ((r2.y1<=r1.y1) && (r1.y1<=r2.y2))||
	   ((r2.y1<=r1.y2) && (r1.y2<=r2.y2))
	   );
}
#endif
