#include "core_except.h"
#include "mod_tim.h"
#include "mod_timecalc.h"

CTime g_tNow;

// Contruct CTime objects
CTime::CTime(){
  m_bInitialized = false;
}

CTime::CTime(char * pValue, bool now) : m_bNow(now) {
  if(now)
    strcpy(m_tValue, g_tNow.m_tValue);
  else
    strcpy(m_tValue, pValue);
  m_bInitialized = true;
}

// Retrieve information
bool CTime::IsNow()    const {
  ASSERT(m_bInitialized);
  return m_bNow;
}

bool operator < (const CTime & t1, const CTime & t2){
  ASSERT(t1.m_bInitialized && t2.m_bInitialized);
  return strcmp(t1.AsString(), t2.AsString())<0;
}

bool operator > (const CTime & t1, const CTime & t2){
  ASSERT(t1.m_bInitialized && t2.m_bInitialized);
  return strcmp(t1.AsString(), t2.AsString())>0;
}

bool operator == (const CTime & t1, const CTime & t2){
  ASSERT(t1.m_bInitialized && t2.m_bInitialized);
  return strcmp(t1.AsString(), t2.AsString())==0;
}

CTime & MostSig(CTime & t1, CTime & t2){
  ASSERT(t1==t2);
  return (t1.IsNow()) ? t1 : t2;
}

CTime Max(CTime t1, CTime t2){
  if(t1<t2) return t2;
  if(t1>t2) return t1;
  return MostSig(t1,t2);
}

CTime Min(CTime & t1, CTime & t2){
  if(t1<t2) return t1;
  if(t1>t2) return t2;
  return MostSig(t1,t2);
}

bool CTime::IsPointLater(const CTime & t) const {
  TimeRecord tr;
  char buffer[80];

  StrToTime(tr,AsString());
  AddSecond(tr,1);
  TimeToStr(tr,buffer);
  return strcmp(buffer,t.AsString())>=0;
}
