/*!****************************************************************************/
/*! File:      trans.pl                                                       */
/*! Project:   Tiger                                                          */
/*! Software:  SWI Prolog 2.7.16, Oracle 8.0.4                                */
/*! Export:                                                                   */
/*!            t_trans_query/3 (interpret.pl,views.pl,eval.pl,constraint.pl)  */
/*!                                                                           */
/*! Import:                                                                   */
/*!            u_query_expr/3 (unparser.pl)                                   */
/*!            r_leftmost_select/2 (rewrite.pl)                               */
/*!            r_realias_cols/3 (rewrite.pl)                                  */
/*!            m_table_type/3 (meta.pl)                                       */
/*!            f_raise_err/2 (fejl.pl)                                        */
/*!****************************************************************************/

determine_mode(flag(vt(seq,_),tt(seq,_),_), bi) :- !.  /* bi-temporal  */
determine_mode(flag(vt(seq,_),_,_), ut) :- !.          /* uni-temporal */
determine_mode(flag(_,tt(seq,_),_), ut) :- !.          /* uni-temporal */
determine_mode(_, nt).                                 /* non-temporal */

%% determine_col_types(+Flag, +QueryExpression, -TypeList)
determine_col_types(flag(_,_,VTR), values(VL), TypeList) :- !,
  findall(T, (member(E,VL), r_type(E,T)), TypeList1),
  (VTR\==nil -> TypeList=[per|TypeList1]; TypeList=TypeList1).
determine_col_types(flag(vt(VTM,_),tt(TTM,_),VTR), QE, TypeList) :-
  r_leftmost_select(QE, S),
  findall(T, (member(sel_col(C,_),S), r_type(C,T)), TypeList1),
  (  VTM == seq
  -> TypeList2 = [per|TypeList1]
  ;  VTR \== nil
  -> TypeList2 = [per|TypeList1]
  ;  TypeList2 = TypeList1
  ),
  (TTM == seq -> TypeList = [per|TypeList2]; TypeList = TypeList2).

/******************************************************************************/

%% trans_orderby(+OrderBy, -OrderBy)
trans_orderby(OB,OB).

%% t_trans_query(+ATSQLQuery, -TypeList, -SQLQuery)
t_trans_query(query(Flag,QExpr,Coal,Order),TypeL,query(nil,QExpr2,nil,Order1)) :-
  determine_col_types(Flag, QExpr, TypeL),
  determine_mode(Flag, Mode),
  trans_query_expr(Mode, QExpr, Flag, QExpr1),
  trans_coal(Coal, Mode, QExpr1, QExpr2),
  trans_orderby(Order, Order1).

/************************* domain specifications ******************************/

%% adjust_dom(+Select, +TimeColName, +Domain, -Select, -WhereCond)
adjust_dom(S, nil, _, S, true) :- !.
adjust_dom([], _, _, [], true).
adjust_dom([sel_col(V,N)|S],N,D,[sel_col(isct([V,D]),N)|S],rel(ove,V,D)) :- !.
adjust_dom([X|S], N, D, [X|S1], W) :- adjust_dom(S, N, D, S1, W).

%% trans_domain(+Flag, +SQLQueryExpression, -SQLQueryExpression)
trans_domain(Flag, union(A,B), union(A1,B1)) :- !,
  trans_domain(Flag, A, A1),
  trans_domain(Flag, B, B1).
trans_domain(Flag, except(A,B), except(A1,B1)) :- !,
  trans_domain(Flag, A, A1),
  trans_domain(Flag, B, B1).
trans_domain(Flag, isct(A,B), isct(A1,B1)) :- !,
  trans_domain(Flag, A, A1),
  trans_domain(Flag, B, B1).
trans_domain(flag(vt(_,VTD),tt(_,TTD),_),
             sel(M,S,F,W,G,H), sel(M,S2,F,and(W,and(W1,W2)),G,H)) :- !,
  adjust_dom(S, "VT$", VTD, S1, W1),
  adjust_dom(S1, "TT$", TTD, S2, W2).

/**************************** range specification *****************************/

%% trans_range(+SQLSelectList, +Flag, -SQLSelectList)
trans_range(Sel, flag(_,_,nil), Sel) :- !.
trans_range([TT,_|S], flag(vt(seq,_),tt(seq,_),VTR),
            [TT,sel_col(VTR1,"VT$")|S]) :- !,
  trans_expr(nt, VTR, flag(vt(seq,_),tt(seq,_),VTR), VTR1).
trans_range([_|S], flag(vt(seq,_),TTF,VTR), [sel_col(VTR1,"VT$")|S]) :- !,
  trans_expr(nt, VTR, flag(vt(seq,_),TTF,VTR), VTR1).
trans_range([TT|S], flag(VTF,tt(seq,_),VTR), [TT,sel_col(VTR1,"VT$")|S]) :- !,
  trans_expr(nt, VTR, flag(VTF,tt(seq,_),VTR), VTR1).
trans_range(Sel, flag(VTF,TTF,VTR), [sel_col(VTR1,"VT$")|Sel]) :-
  trans_expr(nt, VTR, flag(VTF,TTF,VTR), VTR1).

/************************************* coalescing *****************************/

%% trans_coal(+Coalescing, +Mode, +QueryExpr, -QueryExpr)
trans_coal(nil, _, QExpr, QExpr).
trans_coal(nil+nil, _, QExpr, QExpr).
trans_coal(nil+vt, ut, QExpr,
           sel(all,S1,[tab_ref(TabN,TabN,nil)],true,[],true)) :- 
  u_query_expr(QExpr, QStr , []),
  pl_coal_temp_vt(QStr, TabN),
  r_leftmost_select(QExpr,S),
  r_realias_cols(S,TabN,S1).
trans_coal(nil+tt, ut, QExpr,
           sel(all,S1,[tab_ref(TabN,TabN,nil)],true,[],true)) :- 
  u_query_expr(QExpr, QStr , []),
  pl_coal_temp_tt(QStr, TabN),
  r_leftmost_select(QExpr,S),
  r_realias_cols(S,TabN,S1).
trans_coal(nil+vt, bi, QExpr,
           sel(all,S1,[tab_ref(TabN,TabN,nil)],true,[],true)) :- 
  u_query_expr(QExpr, QStr , []),
  pl_coal_bitemp_vt(QStr, TabN),
  r_leftmost_select(QExpr,S),
  r_realias_cols(S,TabN,S1).
trans_coal(nil+tt, bi, QExpr,
           sel(all,S1,[tab_ref(TabN,TabN,nil)],true,[],true)) :- 
  u_query_expr(QExpr, QStr , []),
  pl_coal_bitemp_tt(QStr, TabN),
  r_leftmost_select(QExpr,S),
  r_realias_cols(S,TabN,S1).
trans_coal(tt+vt, bi, QExpr,
           sel(all,S1,[tab_ref(TabN,TabN,nil)],true,[],true)) :- 
  u_query_expr(QExpr, QStr , []),
  pl_coal_bitemp_vt(QStr, Str1),
  append("SELECT * FROM ", Str1, Str2),
  pl_coal_bitemp_tt(Str2, TabN),
  r_leftmost_select(QExpr,S),
  r_realias_cols(S,TabN,S1).
trans_coal(vt+tt, bi, QExpr,
           sel(all,S1,[tab_ref(TabN,TabN,nil)],true,[],true)) :- 
  u_query_expr(QExpr, QStr , []),
  pl_coal_bitemp_tt(QStr, Str1),
  append("SELECT * FROM ", Str1, Str2),
  pl_coal_bitemp_vt(Str2, TabN),
  r_leftmost_select(QExpr,S),
  r_realias_cols(S,TabN,S1).

/******************************************************************************/

%% trans_tuc_cond2(+TimeDimension, +TimeMode, +TableAlias, -WhereCond)
trans_tuc_cond2(vt, tuc, TabAlias, rel(con,vtime(TabAlias),now)) :- !.
trans_tuc_cond2(tt, tuc, TabAlias, rel(con,ttime(TabAlias),now)) :- !.
trans_tuc_cond2(_, _, _, true) :- !.

%% trans_tuc_cond(+Flag, +ATSQLTableDefinition, +TableAlias, -WhereCondition)
trans_tuc_cond(flag(vt(VTM,_),tt(TTM,_),_), TabDef, TabAlias, and(W,W1)) :-
  m_table_type(TabDef,[],TabType),
  (memberchk(TabType,[vt,bi]) -> trans_tuc_cond2(vt, VTM, TabAlias, W); W=true),
  (memberchk(TabType,[tt,bi]) -> trans_tuc_cond2(tt, TTM, TabAlias, W1); W1=true).

/******************************************************************************/

%% trans_temporal_join(+Flag, +FromList, +SelList, +WhereCond, -SelList, -WhereCond)
trans_temporal_join(flag(vt(seq,_),tt(seq,_),_), [tab_ref(_,TabA,_)], S, W,
    [sel_col(ttime(TabA),"TT$"),sel_col(vtime(TabA),"VT$")|S], W) :- !.
trans_temporal_join(flag(vt(seq,_),tt(seq,_),_), F, S, W,
    [sel_col(isct(TTList),"TT$"),sel_col(isct(VTList),"VT$")|S],
    and(rel(lq,begin(isct(TTList)),end(isct(TTList))),
        and(rel(lq,begin(isct(VTList)),end(isct(VTList))),W))) :- !,
  findall(vtime(TabAlias), member(tab_ref(_,TabAlias,_),F), VTList),
  findall(ttime(TabAlias), member(tab_ref(_,TabAlias,_),F), TTList).
trans_temporal_join(flag(vt(seq,_),_,_), [tab_ref(_,TabA,_)], S, W,
                    [sel_col(vtime(TabA),"VT$")|S], W) :- !.
trans_temporal_join(flag(vt(seq,_),_,_), F, S, W,
    [sel_col(isct(VTList),"VT$")|S],
    and(rel(lq,begin(isct(VTList)),end(isct(VTList))),W)) :- !,
  findall(vtime(TabAlias), member(tab_ref(_,TabAlias,_),F), VTList).
trans_temporal_join(flag(_,tt(seq,_),_), [tab_ref(_,TabA,_)], S, W,
                    [sel_col(ttime(TabA),"TT$")|S],W) :- !.
trans_temporal_join(flag(_,tt(seq,_),_), F, S, W,
    [sel_col(isct(TTList),"TT$")|S],
    and(rel(lq,begin(isct(TTList)),end(isct(TTList))),W)) :- !,
  findall(ttime(TabAlias), member(tab_ref(_,TabAlias,_),F), TTList).
trans_temporal_join(_, _, S, W, S, W).

/******************************************************************************/

%% trans_expr(+Mode, +Expr, +Flag, -Expr
trans_expr(_, E, _, E).

/******************************************************************************/

trans_coal(tt+vt, bi, QExpr,
           sel(all,S1,[tab_ref(TabN,TabN,nil)],true,[],true)) :- 
  u_query_expr(QExpr, QStr , []),
  pl_coal_bitemp_vt(QStr, Str1),
  append("SELECT * FROM ", Str1, Str2),
  pl_coal_bitemp_tt(Str2, TabN),
  r_leftmost_select(QExpr,S),
  r_realias_cols(S,TabN,S1).

%% trans_query_expr(+Mode, +ATSQLQueryExpr, +Flag, -SQL92QueryExpr)
trans_query_expr(M, union(A,B), Flag, union(A1,B1)) :- !,
  trans_query_expr(M, A, Flag, A1),
  trans_query_expr(M, B, Flag, B1).
trans_query_expr(nt, except(A,B), Flag, except(A1,B1)) :- !,
  trans_query_expr(nt, A, Flag, A1),
  trans_query_expr(nt, B, Flag, B1).
trans_query_expr(ut, except(A,B), Flag,
         sel(all,[sel_col(all,_)],[tab_ref(TabN,TabN,nil)],true,[],true)) :- !,
  trans_query_expr(bi, A, Flag, A1),
  u_query_expr(A1, Q1, []),
  trans_query_expr(bi, B, Flag, B1),
  u_query_expr(B1, Q2 , []),
  (  Flag = flag(vt(seq,_),_,_)
  -> pl_diff_temp_vt(Q1, Q2, TabN)
  ;  pl_diff_temp_tt(Q1, Q2, TabN)
  ).
trans_query_expr(bi, except(A,B), Flag,
         sel(all,[sel_col(all,_)],[tab_ref(TabN,TabN,nil)],true,[],true)) :- !,
  trans_query_expr(bi, A, Flag, A1),
  u_query_expr(A1, Q1, []),
  trans_query_expr(bi, B, Flag, B1),
  u_query_expr(B1, Q2 , []),
  pl_diff_bitemp(Q1, Q2, TabN).
trans_query_expr(nt, isct(A,B), Flag, isct(A1,B1)) :- !,
  trans_query_expr(nt, A, Flag, A1),
  trans_query_expr(nt, B, Flag, B1).
trans_query_expr(Mode, sel(M,S,F,W,G,H), Flag, sel(M,S2,F1,W3,G,H)) :- !,
  trans_from(F, Flag, F1, W1),
  trans_where(Mode, and(W,W1), Flag, W2),
  trans_temporal_join(Flag, F1, S, W2, S1, W3),
  trans_range(S1, Flag, S2).
trans_query_expr(_, values(EL), flag(_,_,nil), values(EL)) :- !.
trans_query_expr(_, values(EL), flag(_,_,VTR), values([VTR|EL])).

%% trans_from(+From, +Flag, -From, -Where)
trans_from([], _, [], true) :- !.
trans_from([tab_ref(derived_tab(Flag1,QExpr),TabAlias,Coal)|F], Flag,
           [tab_ref(derived_tab(nil,QExpr2),TabAlias,nil)|F1],
	   and(W,W1)) :- !,
  t_trans_query(query(Flag1,QExpr,Coal,[]), _, query(nil,QExpr1,nil,[])),
  trans_domain(Flag, QExpr1, QExpr2),
  trans_tuc_cond(Flag, derived_tab(Flag1,QExpr), TabAlias, W),
  trans_from(F, Flag, F1, W1).
trans_from([tab_ref(TabName,TabAlias,nil+nil)|F], Flag,
           [tab_ref(TabName,TabAlias,nil)|F1], and(W,W1)) :- !,
  trans_tuc_cond(Flag, TabName, TabAlias, W),
  trans_from(F, Flag, F1, W1).
trans_from([H|_], Flag, _, _) :- f_raise_err(unknown_from_item, H-Flag).

%% trans_where(+Mode, +Where, +Flag, -Where)
trans_where(M, or(A,B), Flag, or(A1,B1)) :- !,
  trans_where(M, A, Flag, A1),
  trans_where(M, B, Flag, B1).
trans_where(M, and(A,B), Flag, and(A1,B1)) :- !,
  trans_where(M, A, Flag, A1),
  trans_where(M, B, Flag, B1).
trans_where(nt, not(W), Flag, not(W1)) :- !,
  trans_where(nt, W, Flag, W1).
trans_where(M, rel(Rel,A,B), Flag, rel(Rel,A1,B1)) :- !,
  trans_expr(M, A, Flag, A1),
  trans_expr(M, B, Flag, B1).
trans_where(nt, in(Expr,QueryExpr), Flag, in(Expr, QueryExpr1)) :- !,
  trans_query_expr(nt, QueryExpr, Flag, QueryExpr1).
trans_where(nt, exists(QueryExpr), Flag, exists(QueryExpr1)) :- !,
  trans_query_expr(nt, QueryExpr, Flag, QueryExpr1).
trans_where(_, W, _, W).

