/*!****************************************************************************/
/*! File:      zeit.pl                                                        */
/*! Project:   Tiger                                                          */
/*! Software:  SWI Prolog 2.7.16, Oracle 8.0.4                                */
/*! Export:                                                                   */
/*!            z_inc_current/0 (interpret.pl)                                 */
/*!            z_get_current/1 (interpret.pl,unparser.pl,eval.pl)             */
/*!            z_p_per/2 (parser.pl)                                          */
/*!            z_p_ts/2 (parser.pl,tiger.pl)                                  */
/*!            z_u_per/8 (unparser.pl)                                        */
/*!            z_u_ts/6 (unparser.pl)                                         */
/*!            z_unfold_per/3 (unparser.pl)                                   */
/*!            z_reduce_start/2 (meta.pl)                                     */
/*!            z_reduce_end/2 (meta.pl)                                       */
/*!            z_inc_ts/3 (eval.pl)                                           */
/*! Import:                                                                   */
/*!            nls_period_seperator/2 (tiger.pl)                              */
/*!            s_scan/2 (scanner.pl)                                          */
/*!            r_type/2 (rewrite.pl)                                          */
/*!****************************************************************************/

%% is_last_day(+Month,+Year,+Day)
is_last_day(_,_,31) :- !.
is_last_day(_,M,30) :- memberchk(M,[4,6,9,11]), !.
is_last_day(_,2,29) :- !.
is_last_day(Y,2,28) :- !, Y mod 4 == 0, Y mod 100 =\= 0.

%% last_day(+Month,+Year,-Day)
last_day(2,J,29) :- J mod 4 =:= 0, !.
last_day(2,_,28) :- !.
last_day(M,_,D)  :- (memberchk(M,[4,6,9,11]) -> D=30 ; D=31).

/******************************************************************************/

%% complete_ts(+Position, +TimePt, ?CompletedTimePt)
complete_ts(_,     now,           now) :- !.
complete_ts(_,     Y/M/D/H/Min/S, Y/M/D/H/Min/S) :- !.
complete_ts(start, Y/M/D/H/Min,   Y/M/D/H/Min/0) :- !.
complete_ts(start, Y/M/D/H,       Y/M/D/H/0/0) :- !.
complete_ts(start, Y/M/D,         Y/M/D/0/0/0) :- !.
complete_ts(start, Y/M,           Y/M/1/0/0/0) :- !.
complete_ts(start, Y,             Y/1/1/0/0/0).
complete_ts(end,   Y/M/D/H/Min,   Y/M/D/H/Min/59) :- !.
complete_ts(end,   Y/M/D/H,       Y/M/D/H/59/59) :- !.
complete_ts(end,   Y/M/D,         Y/M/D/23/59/59) :- !.
complete_ts(end,   Y/M,           Y/M/D/23/59/59) :- !, last_day(M,Y,D).
complete_ts(end,   Y,             Y/12/31/23/59/59).

/******************************************************************************/

inc_ts(Y/12/31/23/59/59, Y1/1/1/0/0/0) :- !, Y1 is Y+1.
inc_ts(Y/M/D/23/59/59, Y/M1/D1/0/0/0) :- !,
  (  is_last_day(Y,M,D)
  -> M1 is M+1, D1=0
  ;  M1=M, D1 is D+1
  ).
inc_ts(Y/M/D/H/59/59, Y/M/D/H1/0/0) :- !, H1 is H+1.
inc_ts(Y/M/D/H/Min/59, Y/M/D/H/Min1/0) :- !, Min1 is Min+1.
inc_ts(Y/M/D/H/Min/S, Y/M/D/H/Min/S1) :- !, S1 is S+1.

/******************************************************************************/

z_inc_current :- 
  (  retract(sysdate(cst(T,ts)))
  -> complete_ts(start,T,T1),
     inc_ts(T1,T2),
     assert(sysdate(cst(T2,ts)))
  ;  true
  ).

/******************************************************************************/

z_get_current(Ts) :- 
  (  clause(sysdate(T),true)
  -> Ts = T
  ;  Ts = sysdate
  ).   

get_tt(TT) :-
   get_time(X),
   convert_time(X,Y,M,D,H,Min,Sec,_),
   TT=cst(Y/M/D/H/Min/Sec,ts).

/******************************************************************************/

z_p_per(str(S),P)      :-
  s_scan(S,T),
  p_per1(P,T,O),
  (  O=[X|_]
  -> f_raise_err(time_fmt, X)
  ;  true
  ).

p_per1(I)              --> p_ts(s,P), p_per2(P,I).

p_per2(S,cst(S-E,per)) --> {nls_period_sep(_,A)}, [A], !, p_ts(e,E).
p_per2(P,cst(P-P,per)) --> [].

z_p_ts(str(S),P)       :- !, s_scan(S,T), p_ts(_,P,T,[]).
z_p_ts(T,P)            :- p_ts(_,P,[T],[]).

p_ts(_,cst(TP,ts))     --> [num(N)], !, p_ts2(month,N,TP).
p_ts(_,anonym)         --> [cap("_")], !.
p_ts(_,var(V,ts))      --> [cap(V)], !.
p_ts(_,TT)             --> [systime], !, {get_tt(TT)}.
p_ts(_,now)            --> [now], !.
p_ts(_,P)              --> [current], !, {z_get_current(P)}.
p_ts(_,sysdate)        --> [sysdate], !.
p_ts(_,F)              --> [forever], !, {forever(F)}.
p_ts(e,F)              --> [], !, {forever(F)}.
p_ts(s,B)              --> [], !, {beginning(B)}.
 
p_ts2(month,N1,TP)     --> ['/'], !, [num(N2)], p_ts2(day,N1/N2,TP).
p_ts2(day,N1,TP)       --> ['/'], !, [num(N2)], p_ts2(hour,N1/N2,TP).
p_ts2(hour,N1,TP)      --> ['~'], !, [num(N2)], p_ts2(minute,N1/N2,TP).
p_ts2(minute,N1,TP)    --> [':'], !, [num(N2)], p_ts2(second,N1/N2,TP).
p_ts2(second,N1,N1/N2) --> [':'], [num(N2)], !.
p_ts2(_,N,N)           --> [].

/******************************************************************************/

%% z_u_per(+PeriodCst, +First, +Middle, +Last, +GranularityFlag, +Language)
z_u_per(cst(S-E,per),PStr,IStr,TStr,Gran,Lang) -->
  PStr,
  z_u_ts(S,Gran,start,Lang),
  IStr,
  z_u_ts(E,Gran,end,Lang),
  TStr.

%% z_u_ts(+Timestamp, +GranularityFlag, +PeriodPosition, +Language)
z_u_ts(now,_,_,sql-evl)  --> "NULL".
z_u_ts(now,G,P,sql-ins)  --> {z_get_current(Ts)}, z_u_ts(Ts,G,P,sql_ins).
z_u_ts(now,_,_,atsql)    --> "NOW".
z_u_ts(sysdate,_,_,_)    --> "SYSDATE".
z_u_ts(cst(T,ts),G,P,_)  --> u_ts(T,G,P).

u_ts(T, no_auto_gran, _) --> u_ts1(T).
u_ts(T, auto_gran, Pos)  -->
  {complete_ts(Pos,T,T1)}, "TO_DATE('", u_ts1(T1), "','SYYYY/MM/DD~HH24:Mi:SS')".

u_num(N) --> {number_chars(N,S)}, S.

u_ts1(Y/M/D/H/Mi/S)    --> !, u_num(Y), "/", u_num(M), "/", u_num(D), "~",
                              u_num(H), ":", u_num(Mi), ":", u_num(S).
u_ts1(Y/M/D/H/Mi)      --> !, u_num(Y), "/", u_num(M), "/", u_num(D), "~",
                              u_num(H), ":", u_num(Mi).
u_ts1(Y/M/D/H)         --> !, u_num(Y), "/", u_num(M), "/", u_num(D), "~",
                              u_num(H).
u_ts1(Y/M/D)           --> !, u_num(Y), "/", u_num(M), "/", u_num(D).
u_ts1(Y/M)             --> !, u_num(Y), "/", u_num(M).
u_ts1(Y)               --> !, u_num(Y).

/******************************************************************************/

z_unfold_per(cst(S-now,per), S, null) :- !.
z_unfold_per(cst(S-E,per), S, E) :- !.
z_unfold_per(period(S,E), S, E) :- !.
z_unfold_per(col_ref(T,C,per), col_ref(T,C+"$S",_), col_ref(T,C+"$E",_)) :- !.
z_unfold_per(vtime(T), col_ref(T,"VT$$S",_), col_ref(T,"VT$$E",_)) :- !.
z_unfold_per(ttime(T), col_ref(T,"TT$$S",_), col_ref(T,"TT$$E",_)) :- !.
z_unfold_per(isct(PerList), gst(SList), lst(EList)) :- !,
  findall(S, (member(P,PerList),z_unfold_per(P,S,_)), SList),
  findall(E, (member(P,PerList),z_unfold_per(P,_,E)), EList).
z_unfold_per(TS, TS, TS) :- r_type(TS, ts).

/******************************************************************************/

beginning(cst(-4000/1/1/0/0/0,ts)).

forever(cst(9000/1/1/0/0/0,ts)).

always(ts(X-Y)) :- beginning(X), forever(Y).

/******************************************************************************/

%% z_reduce_start(+TimePtStr,?ReducedTimePtStr)
z_reduce_start("-4000/01/01~00:00:00","BEGINNING") :- !.
z_reduce_start(" 9000/01/01~00:00:00"," FOREVER") :- !.
z_reduce_start(I,O) :- append(O,"/01/01",I), !.
z_reduce_start(I,O) :- append(O,"/01/01~00:00",I), !.
z_reduce_start(I,O) :- append(O,"/01/01~00:00:00",I), !.
z_reduce_start(I,O) :- append(O,"/01~00:00:00",I), !.
z_reduce_start(I,O) :- append(O,"~00:00:00",I), !.
z_reduce_start(I,O) :- append(O,":00:00",I), !.
z_reduce_start(I,O) :- append(O,":00",I), !.
z_reduce_start(I,I) :- !.

%% z_reduce_end(+TimePtStr,?ReducedTimePtStr)
z_reduce_end("-4000/01/01~00:00:00","BEGINNING") :- !.
z_reduce_end(" 9000/01/01~00:00:00"," FOREVER") :- !.
z_reduce_end(I,O) :- append(O,"/12/31",I), !.
z_reduce_end(I,O) :- append(O,"/12/31~23:59",I), !.
z_reduce_end(I,O) :- append(O,"/12/31~23:59:59",I), !.
z_reduce_end(I,O) :- append(O,"/31~23:59:59",I), !.
z_reduce_end(I,O) :- append(O,"~23:59:59",I), !.
z_reduce_end(I,O) :- append(O,":59:59",I), !.
z_reduce_end(I,O) :- append(O,":59",I), !.
z_reduce_end(I,I) :- !.

/******************************************************************************/

%% z_inc_ts(+TimeStamp, +Increment, -IncrementedTimeStamp)
z_inc_ts(TS, Num, add_grl(TS,sec,Num)).

/******************************************************************************/

test_flag :-
  unix(argv(Args)),
  nth0(I1,Args,'--'),
  nth0(I2,Args,'-s'),
  I2>I1.
