--Create the P_Audit triggers
--Connect to db
CONNECT TO cs560

--Drop the triggers and tables if they exist
DROP TRIGGER Delete_PROJECTIONS
DROP TRIGGER Update_PROJECTIONS
DROP TRIGGER Insert_PROJECTIONS
DROP TABLE P_AUDIT

--Create the table
CREATE TABLE P_AUDIT (PROJECTION_ID INT NOT NULL, PROJECTION_NAME INT, PROJECTION_TYPE INT, SPHEROID_CODE INT, PROJECTION_UOM INT, ZONE_CODE INT, When_Changed TIMESTAMP NOT NULL, PRIMARY KEY (PROJECTION_ID, When_Changed))

--Create the triggers
CREATE TRIGGER Delete_PROJECTIONS AFTER DELETE ON PROJECTIONS REFERENCING OLD AS O FOR EACH ROW MODE DB2SQL BEGIN ATOMIC INSERT INTO P_Audit VALUES (O.PROJECTION_ID, O.PROJECTION_NAME, O.PROJECTION_TYPE, O.SPHEROID_CODE, O.PROJECTION_UOM, O.ZONE_CODE, CURRENT TIMESTAMP); END

CREATE TRIGGER Update_PROJECTIONS AFTER UPDATE ON PROJECTIONS REFERENCING OLD AS O FOR EACH ROW MODE DB2SQL BEGIN ATOMIC INSERT INTO P_Audit VALUES (O.PROJECTION_ID, O.PROJECTION_NAME, O.PROJECTION_TYPE, O.SPHEROID_CODE, O.PROJECTION_UOM, O.ZONE_CODE, CURRENT TIMESTAMP); END


QUIT

