--Create delete trigger
CREATE TRIGGER Delete_PROJECTIONS 
AFTER DELETE ON PROJECTIONS 
REFERENCING OLD AS O FOR EACH ROW MODE DB2SQL 
BEGIN ATOMIC 
  INSERT INTO P_Audit VALUES (O.PROJECTION_ID, 
                              O.PROJECTION_NAME,
                              O.PROJECTION_TYPE, 
                              O.SPHEROID_CODE, 
                              O.PROJECTION_UOM, 
                              O.ZONE_CODE,
                              CURRENT TIMESTAMP); 
END


--Create update trigger
CREATE TRIGGER Update_PROJECTIONS 
AFTER UPDATE ON PROJECTIONS
REFERENCING OLD AS O FOR EACH ROW MODE DB2SQL 
BEGIN ATOMIC 
INSERT INTO P_Audit VALUES (O.PROJECTION_ID, 
                            O.PROJECTION_NAME, 
                            O.PROJECTION_TYPE,
                            O.SPHEROID_CODE, 
                            O.PROJECTION_UOM, 
                            O.ZONE_CODE, 
                            CURRENT TIMESTAMP);
END

