--Drop the old update and delete triggers
DROP TRIGGER Delete_PROJECTIONS;
DROP TRIGGER Update_PROJECTIONS;

--Create new delete trigger, stores no data
CREATE TRIGGER Delete_PROJECTIONS 
AFTER DELETE ON PROJECTIONS 
FOR EACH ROW
BEGIN
  INSERT INTO P_Audit VALUES (:old.PROJECTION_ID, 
                              NULL,
                              NULL, 
                              NULL, 
                              NULL, 
                              NULL,
                              SYSDATE,
                              'D'); 
END;
/

--Create new update trigger, stores after image
CREATE TRIGGER Update_PROJECTIONS 
AFTER UPDATE ON PROJECTIONS
FOR EACH ROW
BEGIN
INSERT INTO P_Audit VALUES (:new.PROJECTION_ID, 
                            :new.PROJECTION_NAME, 
                            :new.PROJECTION_TYPE,
                            :new.SPHEROID_CODE, 
                            :new.PROJECTION_UOM, 
                            :new.ZONE_CODE, 
                            SYSDATE,
                            'U');
END;
/
