DROP TRIGGER Delete_PROJECTIONS;
DROP TRIGGER Update_PROJECTIONS;
DROP TRIGGER Insert_PROJECTIONS;

--Create delete trigger
CREATE TRIGGER Delete_PROJECTIONS 
AFTER DELETE ON PROJECTIONS 
FOR EACH ROW
BEGIN
  INSERT INTO P_Audit VALUES (:old.PROJECTION_ID, 
                              :old.PROJECTION_NAME,
                              :old.PROJECTION_TYPE, 
                              :old.SPHEROID_CODE, 
                              :old.PROJECTION_UOM, 
                              :old.ZONE_CODE,
                              SYSDATE); 
END; 
/

--Create update trigger
CREATE TRIGGER Update_PROJECTIONS 
AFTER UPDATE ON PROJECTIONS
FOR EACH ROW
BEGIN
INSERT INTO P_Audit VALUES (:old.PROJECTION_ID, 
                            :old.PROJECTION_NAME, 
                            :old.PROJECTION_TYPE,
                            :old.SPHEROID_CODE, 
                            :old.PROJECTION_UOM, 
                            :old.ZONE_CODE, 
                            SYSDATE);
END;
/

