#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <time.h>
#include <sys/time.h>
#include <dbi.h>
#include <stdio.h>


void SetupTables(void);
void PopulateTable(void);
void Backlog(void);
void ClearTables();
void Reconstruct_after(void);
void Reconstruct_current(void);
void OutputTables(void);
void set_date(DB_OBJECT*);

main()
{
uci_startup ("reco4");

EXEC SQLX CONNECT 'AuditTrail';

	SetupTables();
	ClearTables(); 
	Backlog();
	PopulateTable();
	Reconstruct_after();
	Reconstruct_current();
	OutputTables();

EXEC SQLX DISCONNECT ;
}


void SetupTables()
{
	EXEC SQLX CREATE TABLE PROJECTIONS (	PROJECTION_ID	INT,
						PROJECTION_NAME	INT,
						PROJECTION_TYPE	INT,
						SPHEROID_CODE	INT,
						PROJECTION_UOM	INT,
						ZONE_CODE	INT
					);

	EXEC SQLX CREATE TABLE P_Audit (	PROJECTION_ID	INT,
						PROJECTION_NAME	INT,
						PROJECTION_TYPE	INT,
						SPHEROID_CODE	INT,
						PROJECTION_UOM	INT,
						ZONE_CODE	INT ,
						When_Changed   DATE ,
						OP INT,
						PRIMARY KEY (PROJECTION_ID,When_Changed)
					);	

	EXEC SQLX COMMIT WORK;

	EXEC SQLX ALTER CLASS P_Audit ADD METHOD set_date() FUNCTION set_date 
	FILE './reco4.o';

	EXEC SQLX COMMIT WORK;

}

void ClearTables(void)
{
	EXEC SQL DELETE FROM PROJECTIONS;
	EXEC SQL DELETE FROM P_Audit;
	EXEC SQLX COMMIT WORK;
} 


void PopulateTable(void)
{

	EXEC SQL INSERT INTO PROJECTIONS VALUES (1, 1, 12, 1, 1, 1);
	EXEC SQLX COMMIT WORK;

	EXEC SQL INSERT INTO PROJECTIONS VALUES (2, 1, 10, 1, 1, 1);
	EXEC SQLX COMMIT WORK;

	EXEC SQL INSERT INTO PROJECTIONS VALUES (3, 1, 15, 1, 1, 1);
	EXEC SQLX COMMIT WORK;

	EXEC SQL INSERT INTO PROJECTIONS VALUES (4, 1, 17, 1, 1, 1);
	EXEC SQLX COMMIT WORK;

	EXEC SQL INSERT INTO PROJECTIONS VALUES (5, 1, 18, 1, 1, 1);
	EXEC SQLX COMMIT WORK;

	EXEC SQL DELETE FROM PROJECTIONS WHERE PROJECTION_ID = 5;
	EXEC SQLX COMMIT WORK;

	EXEC SQL UPDATE PROJECTIONS SET PROJECTION_TYPE = 13  WHERE  PROJECTION_ID = 2;
	EXEC SQLX COMMIT WORK;

	EXEC SQL INSERT INTO PROJECTIONS VALUES (5,1,19,1,1,1);
	EXEC SQLX COMMIT WORK;

	EXEC SQL UPDATE PROJECTIONS SET PROJECTION_TYPE = 11  WHERE  PROJECTION_ID = 3;
	EXEC SQLX COMMIT WORK;

	EXEC SQL UPDATE PROJECTIONS SET PROJECTION_TYPE = 14  WHERE  PROJECTION_ID = 2;
	EXEC SQLX COMMIT WORK; 

	EXEC SQL DELETE FROM PROJECTIONS WHERE PROJECTION_ID = 4;
	EXEC SQLX COMMIT WORK;

	EXEC SQL INSERT INTO PROJECTIONS VALUES (4,1,18,1,1,1);
	EXEC SQLX COMMIT WORK;

}

void Backlog(void)
{
	 EXEC SQLX
		CREATE TRIGGER Delete_PROJECTION
		BEFORE DELETE ON PROJECTIONS
		EXECUTE
			INSERT INTO P_Audit VALUES
			(obj.PROJECTION_ID,0,0,0,0,0,DATE '01/01/1800',1);
	EXEC SQLX COMMIT WORK;


	EXEC SQLX 
		CREATE TRIGGER Update_PROJECTION
		BEFORE UPDATE ON PROJECTIONS
		EXECUTE
			INSERT INTO P_Audit VALUES
			(new.PROJECTION_ID,new.PROJECTION_NAME,new.PROJECTION_TYPE,new.SPHEROID_CODE,new.PROJECTION_UOM,new.ZONE_CODE,DATE '01/01/1800',2);
	EXEC SQLX COMMIT WORK;


	EXEC SQLX 
		CREATE TRIGGER Insert_PROJECTION
		AFTER INSERT ON PROJECTIONS
		EXECUTE
			INSERT INTO P_Audit
			VALUES(obj.PROJECTION_ID,obj.PROJECTION_NAME,obj.PROJECTION_TYPE,obj.SPHEROID_CODE,obj.PROJECTION_UOM,obj.ZONE_CODE,DATE
			'01/01/1800',3);
	EXEC SQLX COMMIT WORK;

	
	EXEC SQLX
		CREATE TRIGGER Insert_P_Audit
		AFTER INSERT ON P_Audit
		EXECUTE
			CALL set_date() on obj;

	EXEC SQLX COMMIT WORK;

}

void set_date(DB_OBJECT *obj)
{
EXEC SQLX BEGIN DECLARE SECTION;
DB_VALUE d;
struct timeval  time_sec;
struct tm       *cur_time;
EXEC SQLX END DECLARE SECTION;

	gettimeofday(&time_sec, NULL);
	cur_time = localtime(&time_sec.tv_sec);

	db_make_date(&d,cur_time->tm_mon+1,cur_time->tm_mday,cur_time->tm_year+1900);
	db_put(obj,"When_Changed",&d);
	EXEC SQLX COMMIT WORK;
}


void Reconstruct_after(void)
{

EXEC SQLX BEGIN DECLARE SECTION;
int id;
int type;
int name;
EXEC SQLX END DECLARE SECTION;

EXEC SQLX DECLARE reco_after CURSOR FOR
   SELECT PROJECTION_ID, PROJECTION_NAME, PROJECTION_TYPE, SPHEROID_CODE,
   PROJECTION_UOM, ZONE_CODE
   FROM P_Audit AS A
   WHERE A.When_Changed = (SELECT MAX(A2.When_Changed)
			FROM P_Audit AS A2
			WHERE A.PROJECTION_ID = A2.PROJECTION_ID
			AND A.When_Changed < DATE '08/01/1997')
      AND A.OP <> 1;

    EXEC SQLX OPEN reco_after FOR READ ONLY;

    fprintf(stdout, "-------------------\n");
    fprintf(stdout, "Reconstructed Table\n");
    fprintf(stdout, "--------------------\n");
    fprintf(stdout, "PROJECTION_ID  PROJECTION_TYPE\n", id, type,SQLERRMC);
    fprintf(stdout, "------------------------------\n");

    for (;;)
    {
	  EXEC SQLX WHENEVER NOT FOUND GOTO not_f;

	  EXEC SQLX FETCH reco_after INTO :id, :name, :type;

	  fprintf(stdout, "%d                  %d\n", id, type, SQLERRMC);
    }

not_f : 
     EXEC SQLX CLOSE reco_after;

}


void Reconstruct_current(void)
{
EXEC SQLX BEGIN DECLARE SECTION;
int id;
int type;
int name;
EXEC SQLX END DECLARE SECTION;

EXEC SQLX DECLARE reco_curr CURSOR FOR
  SELECT PROJECTION_ID, PROJECTION_NAME, PROJECTION_TYPE,
  SPHEROID_CODE,PROJECTION_UOM, ZONE_CODE
  FROM P_Audit AS A
  WHERE A.When_Changed = (SELECT MAX(A2.When_changed)
			  FROM P_Audit AS A2
			  WHERE A.PROJECTION_ID = A2.PROJECTION_ID)
   AND A.OP <> 1;

EXEC SQLX OPEN reco_curr FOR READ ONLY;

    fprintf(stdout, "---------------------------\n");
    fprintf(stdout, "Reconstructed Current Table\n");
    fprintf(stdout, "----------------------------\n");
    fprintf(stdout, "PROJECTION_ID  PROJECTION_TYPE\n", id, type,SQLERRMC);
    fprintf(stdout, "------------------------------\n");
    

     for (;;)
	 {
	   EXEC SQLX WHENEVER NOT FOUND GOTO not_fd;

           EXEC SQLX FETCH reco_curr INTO :id, :name, :type;

           fprintf(stdout, "%d                 %d\n", id, type, SQLERRMC);
         }

   not_fd :
	EXEC SQLX CLOSE reco_curr;

}

void OutputPROJECTION(void)
{
EXEC SQLX BEGIN DECLARE SECTION;
int id;
int type;
EXEC SQLX END DECLARE SECTION;

        /*
                Output PROJECTION table
        */
        EXEC SQLX DECLARE proj CURSOR FOR
                SELECT PROJECTION_ID, PROJECTION_TYPE
                FROM PROJECTIONS;

        EXEC SQLX OPEN proj FOR READ ONLY;

        fprintf(stdout,"------------------\n");
        fprintf(stdout, "PROJECTION table\n");
        fprintf(stdout,"-------------------\n");
        fprintf(stdout, "PROJECTION_ID  PROJECTION_TYPE\n", id, type, SQLERRMC);
        fprintf(stdout,"--------------------------------\n");
        for (;;)
        {
                EXEC SQLX WHENEVER NOT FOUND GOTO not_found;

                EXEC SQLX FETCH proj INTO :id, :type;

                fprintf(stdout, "%d                  %d  %s\n", id, type, SQLERRMC);
        }

not_found:
        EXEC SQLX CLOSE proj;
}


void OutputP_Audit(void)
{
EXEC SQLX BEGIN DECLARE SECTION;
int id;
int type;
DB_DATE ts;
int op;
char buf[20];
EXEC SQLX END DECLARE SECTION;

        /*
                Output P_Audit table
        */
        EXEC SQLX DECLARE p_aud CURSOR FOR
                SELECT PROJECTION_ID, PROJECTION_TYPE, When_Changed, OP
                FROM P_Audit;

        EXEC SQLX OPEN p_aud FOR READ ONLY;

        fprintf(stdout, "--------------\n");
        fprintf(stdout, "P_Audit table\n");
        fprintf(stdout, "---------------\n");
        fprintf(stdout, "PROJECTION_ID  PROJECTION_TYPE  When_Changed  OP\n", id, type, SQLERRMC);
        fprintf(stdout,"--------------------------------------------------\n");
        for (;;)
        {
                EXEC SQLX WHENEVER NOT FOUND GOTO not_found;

                EXEC SQLX FETCH p_aud INTO :id, :type, :ts, :op;
		db_date_to_string(buf,20,&ts);

                fprintf(stdout, "%d                  %d            %s       %d\n", id, type,buf,op);
        }

not_found:
        EXEC SQLX CLOSE p_aud;
}


void OutputTables(void)
{
        OutputPROJECTION();
        OutputP_Audit();
	EXEC SQLX DROP TRIGGER Insert_P_Audit;
	EXEC SQLX COMMIT WORK;
	exit(0);
}


