-- When did we think that some property, at some time was owned by the
-- customer who owned at the same time property 7797?
-- Valid-time sequenced and transaction-time sequenced
SELECT P2.property_number, 
       GREATEST( P1.VT_Begin, P2.VT_Begin ) AS VT_Begin,
       LEAST( P1.VT_End, P2.VT_End ) AS VT_End,
       GREATEST( P1.TT_Start, P2.TT_Start ) AS TT_Start,
       LEAST( P1.TT_Stop, P2.TT_Stop ) AS TT_Stop
FROM Prop_Owner P1, Prop_Owner P2
WHERE P1.property_number = 7797
  AND P2.property_number <> P1.property_number
  AND P1.customer_number = P2.customer_number
  AND P1.VT_Begin < P2.VT_End AND P2.VT_Begin < P1.VT_End
  AND P1.TT_Start < P2.TT_Stop AND P2.TT_Start < P1.TT_Stop;
