-- When did we think that some property, at some time, was owned by a customer
-- who owned at any time propertyh 7797?
-- Valid-time nonsequenced and transaction-time sequenced
SELECT P2.property_number,
       GREATEST( P1.TT_Start, P2.TT_Start ) AS Recorded_Start,
       LEAST( P1.TT_Stop, P2.TT_Stop ) AS Recorded_Stop
FROM Prop_Owner P1, Prop_Owner P2
WHERE P1.property_number = 7797
  AND P2.property_number <> P1.property_number
  AND P1.customer_number = P2.customer_number
  AND P1.TT_Start < P2.TT_Stop AND P2.TT_Start < P1.TT_Stop;
