-- Perform a sequenced/nonsequenced query on a join of Customer, Property and Prop_Owner
-- Who has owned the property at Bygaden 4 and when was this infomration recorded?
SELECT name, GREATEST( PO.VT_Begin, C.VT_Begin, P.VT_Begin ) AS VT_Begin,
       LEAST( PO.VT_End, C.VT_End, P.VT_End ) AS VT_End,
FROM Prop_Owner PO, Customer C, Property P
WHERE P.address = 'Bygaden 4'
  AND P.property_number = PO.property_number
  AND C.customer_number = PO.customer_number
  AND GREATEST( PO.VT_Begin, C.VT_Begin, P.VT_Begin ) <
      LEAST( PO.VT_End, C.VT_End, P.VT_End )
  AND GREATEST( PO.TT_Start, C.TT_Start, P.TT_Start ) <
      LEAST( PO.TT_Stop, C.TT_Stop, P.TT_Stop );
