-- Assert that the customer number in Prop_Owner is a foreign key referencing the
-- Customer table.
-- Nontemporal
CREATE OR REPLACE TRIGGER P_O_integrity
AFTER INSERT OR UPDATE OR DELETE  ON Prop_Owner
DECLARE
  valid INTEGER;
BEGIN
 SELECT 1 INTO valid FROM DUAL
 WHERE
  NOT EXISTS 
  ( SELECT * FROM Prop_Owner
    WHERE customer_number NOT IN
    (
      SELECT customer_number FROM Customer
    )
  );
 EXCEPTION
  WHEN NO_DATA_FOUND THEN 
       RAISE_APPLICATION_ERROR( -20001, '' );
END;
/
