-- Assert that customer number in Prop_Owner is a foreign key referencing the Customer
-- table expressed using SQL's relational difference operation EXCEPT
-- Nontemporal
CREATE OR REPLACE TRIGGER P_O_integrity
AFTER INSERT OR UPDATE OR DELETE  ON Prop_Owner
DECLARE
  valid INTEGER;
BEGIN
 SELECT 1 INTO valid FROM DUAL
 WHERE
  NOT EXISTS 
  (
    SELECT customer_number FROM Prop_Owner
    MINUS
    SELECT customer_number FROM Customer
  );
 EXCEPTION
  WHEN NO_DATA_FOUND THEN 
       RAISE_APPLICATION_ERROR( -20001, '' );
END;
/
