--------------------------------------------------------------------
--Description : UnionAll for TJOIN performance measurements
--Author      : Jie Li
--Date        : Dec. 3, 1997
--            : Assumes that the Generated tables have been 
--              properly loaded in database cs560 
--------------------------------------------------------------------

connect to cs560
	
create table emp10RES(EID CHAR(11), StartDate DATE, EndDate DATE)

INSERT INTO emp10RES			        \
SELECT E1.EID, E1.StartDate, E1.EndDate		\
FROM   emp10 E1, emp10 E2			\
WHERE  E1.MID = E2.EID AND			\
       E1.Salary > E2.Salary AND		\
       E2.StartDate <= E1.StartDate AND		\
       E1.EndDate <= E2.EndDate			\
UNION  ALL					\
SELECT E1.EID, E1.StartDate, E2.EndDate		\
FROM   emp10 E1, emp10 E2			\
WHERE  E1.MID = E2.EID AND			\
       E1.Salary > E2.Salary AND		\
       E1.StartDate > E2.StartDate AND		\
       E2.EndDate < E1.EndDate AND		\
       E1.StartDate < E2.EndDate		\
UNION  ALL					\
SELECT E1.EID, E2.StartDate, E1.EndDate		\
FROM   emp10 E1, emp10 E2			\
WHERE  E1.MID = E2.EID AND			\
       E1.Salary > E2.Salary AND		\
       E2.StartDate > E1.StartDate AND		\
       E1.EndDate < E2.EndDate AND		\
       E2.StartDate < E1.EndDate		\
UNION  ALL	    				\
SELECT E1.EID, E2.StartDate, E2.EndDate		\
FROM   emp10 E1, emp10 E2			\
WHERE  E1.MID = E2.EID AND			\
       E1.Salary > E2.Salary AND		\
       E2.StartDate >= E1.StartDate AND		\
       E2.EndDate <= E1.EndDate	AND		\
       NOT (E2.Startdate = E1.StartDate AND	\
	   E2.EndDate = E1.EndDate)

quit
