
// CF 5.2

// Employees table & data

CREATE TABLE Employees(
                        SSN             integer,
                        LastName        char(25),
                        FirstName       char(25),
                        AnnualSalary    integer,
                        BirthDate       date
                      );

INSERT INTO Employees VALUES (
                        111223333,
                        'Smith',
                        'Bob',
                        64000,
                        DATE '04/07/1932'
                             );

INSERT INTO Employees VALUES (
                        444332222,
                        'Brucks',
                        'Eric',
                        32768,
                        DATE '01/06/1969'
                             );

// Incumbents table & data

CREATE TABLE Incumbents (
                        SSN             integer,
                        PCN             integer
                        );

INSERT INTO Incumbents VALUES (
                        111223333,
                        723401
                              );

INSERT INTO Incumbents VALUES (
                        444332222,
                        120033
                              );


// Positions table & data

CREATE TABLE Positions (
                        PCN             integer,
                        JobTitleCode1   integer
                       );

INSERT INTO POSITIONS VALUES (
                        137112,
                        130891
                             );

INSERT INTO POSITIONS VALUES (
                        341288,
                        141955
                             );

INSERT INTO POSITIONS VALUES (
                        120033,
                        132955
                             );

INSERT INTO POSITIONS VALUES (
                        723401,
                        020730
                             );

INSERT INTO POSITIONS VALUES (
                        908654,
                        172734
                             );


// JobTitles table & data

CREATE TABLE JobTitles (
                        JobTitleCode    integer,
                        JobTitle        char(66)
                       );

INSERT INTO JobTitles VALUES (
                        141955,
                        'Associate Director, Computer Center'
                             );

INSERT INTO JobTitles VALUES (
                        130891,
                        'Associate Professor of Computer Science'
                             );

INSERT INTO JobTitles VALUES (
                        110689,
                        'Head, Department of Computer Science'
                             );

INSERT INTO JobTitles VALUES (
                        132955,
                        'Instructor, Computer Science'
                             );

INSERT INTO JobTitles VALUES (
                        020730,
                        'Hazardous Waste Specialist'
                             );

INSERT INTO JobTitles VALUES (
                        172734,
                        'Director, Computer Center'
                             );


// Actual query

SELECT JobTitle
  FROM Employees, Incumbents, Positions, JobTitles
 WHERE FirstName = 'Bob'
   AND Employees.SSN = Incumbents.SSN
   AND Incumbents.PCN = Positions.PCN
   AND Positions.JobTitleCode1 = JobTitles.JobTitleCode;

