/******************************************************************************/
/* Module:      swi.pl                                                        */
/* Project:     TimeDB 1.03                                                   */
/* Author:      Andreas Steiner                                               */
/* Language:    SWI Prolog 2.1.9                                              */
/* Machine:     SPARC/Solaris                                                 */
/* Date:        December 12, 1995                                             */
/* Export:                                                                    */
/*              check_option/1 (timeDB.pl)                                    */
/*              read_from_chars/2 (meta_data.pl)                              */
/*              format_to_chars/3 (meta_data.pl)                              */
/*              select/3 (translate.pl)                                       */
/* Import:                                                                    */
/******************************************************************************/

/* This file must be loaded if you run TimeDB with SWI Prolog */ 

:- current_predicate(init_ora, init_ora) ->
     init_ora;
     use_module('$ORACLE_EMULATOR/oracle').

check_option(O) :- unix(argv(A)), nth0(X,A,'--'), nth0(Y,A,O), X<Y.

sum_list(L,S) :- sum_list2(L,0,S).
sum_list2([],S,S).
sum_list2([H|T],S0,S) :- S1 is H+S0, sum_list2(T,S1,S).

max_list([H|T],M) :- max_list2(T,H,M).
max_list2([],M,M).
max_list2([H|T],X,M) :- H=<X, !, max_list2(T,X,M).
max_list2([H|T],_,M) :- max_list2(T,H,M).

min_list([H|T],M) :- min_list2(T,H,M).
min_list2([],M,M).
min_list2([H|T],X,M) :- H>=X, !, min_list2(T,X,M).
min_list2([H|T],_,M) :- min_list2(T,H,M).


read_from_chars(X,Y) :-
  telling(U), tell('.tmp'), format("~s~n",[X]), told, tell(U),
  seeing(V), see('.tmp'), read(Y), seen, see(V).

format_to_chars(F,A,L) :- sformat(S,F,A), string_to_list(S,L).


:- redefine_system_predicate(select(_,_,_)).
select(X,L,L1) :- system:select(L,X,L1).

:- arithmetic_function(trunc/2).
trunc(X, Y) :- number_chars(X, S1), append(S, [46|_], S1), !, number_chars(Y, S).
trunc(X, X) :- integer(X).

:- arithmetic_function(mod(_,_)).
:- op(300, xfx, mod).
mod(X, Y, Z) :- M is X / Y, trunc(M, M1), Z is X - M1 * Y.

:- arithmetic_function(//(_,_)).
:- op(400, yfx, //).
//(X, Y, Z) :- M is X / Y, trunc(M, Z).

:- assert(prolog(swi)).
