%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Game 1. Where Bob's moves are read from the terminal, and
% Alices moves are random.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
player(
   'Bob1',
   reader,
    boards(
       ["........",
       ".******.",
       "........",
       ".*...*..",
       ".....*..",
       ".....*..",
       ".....*..",
       "........"]
,
      ["........",
       "........",
       "........",
       "........",
       "........",
       "........",
       "........",
       "........"]
   )
).

player(
   'Alice1',
   random,
    boards(
      ["........",
       ".....*..",
       ".....*..",
       ".....*..",
       ".....*..",
       "..*.....",
       "........",
       ".******."]
,
      ["........",
       "........",
       "........",
       "........",
       "........",
       "........",
       "........",
       "........"]
   )
).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Game 2: A game where Bob wins after playing 7,6.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

player(
   'Alice2',
   random,
    boards(
       ["........",
       "........",
       "........",
       "........",
       "........",
       "........",
       ".....*..",
       "........"]
,
      ["........",
       "........",
       "........",
       "........",
       "........",
       "........",
       "........",
       "........"]
   )
).


player(
   'Bob2',
   reader,
    boards(
       ["........",
       ".******.",
       "........",
       ".*...*..",
       ".....*..",
       ".....*..",
       ".....*..",
       "........"]
,
      ["........",
       "........",
       "........",
       "........",
       "........",
       "........",
       "........",
       "........"]
   )
).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Game 3: A game where there's a draw after both players play 7,6.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

player(
   'Alice3',
   reader,
    boards(
       ["........",
       "........",
       "........",
       "........",
       "........",
       "........",
       ".....*..",
       "........"]
,
      ["........",
       "........",
       "........",
       "........",
       "........",
       "........",
       "........",
       "........"]
   )
).


player(
   'Bob3',
   reader,
    boards(
       ["........",
       "........",
       "........",
       "........",
       "........",
       "........",
       ".....*..",
       "........"]
,
      ["........",
       "........",
       "........",
       "........",
       "........",
       "........",
       "........",
       "........"]
   )
).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Print boards.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
board2string([],"").
board2string([Row|Rows],P) :-
   append(Row,"\n",A),
   board2string(Rows,B),
   append(A,B,P).

board2atom(B,A) :-
   board2string(B,S),
   name(A,S).

printBoard(B) :-
   board2atom(B,A),
   write(A).

printBoards(PlayerA,AsShips,AsShots) :-
   write(PlayerA), write(' Ships Board:'), nl, printBoard(AsShips),
   write(PlayerA), write(' Shots Board:'), nl, printBoard(AsShots).

printBoards(PlayerA,PlayerB,AsShips,AsShots,BsShips,BsShots) :-
   printBoards(PlayerA,AsShips,AsShots),
   printBoards(PlayerB,BsShips,BsShots).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Get/Set board entries.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
get(Row,Col,Bin,TheEntry) :- true.

set(Row,Col,Bin,TheEntry,Bout) :- true.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Shooting.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
shoot(Row,Col,AsShots,AsShotsOut,BsShips,BsShipsOut) :-
   true.

oneshot("*","X").
oneshot(".","O").
oneshot("O","O").
oneshot("X","X").

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Player "strategies"
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

move(Player,random,PlayerShots,Row,Col) :-
   length(PlayerShots,L),
   random(1,L,Row),
   random(1,L,Col),
   write(Player), write(' plays '), write(Row), write(','), write(Col), nl.

move(Player,reader,_,Row,Col) :-
   write('Enter row: '), read(Row),
   write('Enter col: '), read(Col),
   write(Player), write(' plays '), write(Row), write(','), write(Col), nl.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Rounds of play
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
done(Ships) :-
   true.

round(PlayerA,AsStrategy,AsShips,AsShots,PlayerB,BsStrategy,BsShips,BsShots) :-
   write('--------------------'), write(PlayerA), write('--------------------'), nl,
   printBoards(PlayerA,PlayerB,AsShips,AsShots1,BsShips1,BsShots),
   write('--------------------'), write(PlayerB), write('--------------------'), nl,
   printBoards(PlayerA,PlayerB,AsShips1,AsShots1,BsShips1,BsShots1),!,
   round(PlayerA,AsStrategy,AsShips1,AsShots1,PlayerB,BsStrategy,BsShips1,BsShots1).
   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Top-level goal.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

battleships(Alice,Bob) :-
   player(Alice,AlicesStrategy,boards(AlicesShips,AlicesShots)),
   player(Bob,BobsStrategy,boards(BobsShips,BobsShots)),
   round('Alice',AlicesStrategy,AlicesShips,AlicesShots,
         'Bob',BobsStrategy,BobsShips,BobsShots).

   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Testing goals.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ships :-
   battleships('Alice1','Bob1').

% Bob enters 7,6, as his first (and only) move, and wins.
bobWins :-
   battleships('Alice2','Bob2').

% Alice and Bob both enter 7,6, resulting in a draw.
aDraw :-
   battleships('Alice3','Bob3').


      