% vowel  -- 1 or more vowels
% cons0  -- 0 or more consonants
% cons1  -- 1 consonant
% consV  -- 1 voiced consonant
% suffix -- 
% vowelF -- Front vowel
% any    -- anything
% none   -- nothing

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                            Letter qualities
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% vowel, etc.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                            prefix match
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
prefix_match(any,_).
prefix_match(none, [blank]).
prefix_match(none, []).

% One or more vowels

% Zero or more consonants

% One consonant

% One voiced consonant

% One front vowel.

% Common suffixes

% One letter

% End of the context

p1 :- prefix_match([vowel],[a]).  % yes
p2 :- prefix_match([vowel],[a,a,a]). % yes
p3 :- prefix_match([vowel,cons1],[a,b]). % yes
p4 :- prefix_match([vowel,cons1],[a,e]). % no
p5 :- prefix_match([vowel,cons1,vowel],[a,l,e]). % yes

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                            suffix match
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                            Matching
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                              tests
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

test(Chars) :-
   match(Chars, Phonemes, Rules), 
   write('Phonemes: '), write(Phonemes), nl, 
   write('Rules: '), write(Rules), nl.

t1 :- test([a,s,e,x,u,a,l]).
t2 :- test([t,h,i,m,b,l,e]).
t3 :- test([h,e,l,l,o,blank,t,h,e,r,e]).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                              main
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load :-
   [match, sentence, phonemes].

talk(S, P) :-
   match(S,P,_).

list2string([],"").
list2string([A|R],R2) :-
   name(A,S),
   list2string(R,R1),
   append(S, " ", S1),
   append(S1,R1,R2).

play(P) :-
   list2string(P,P1),
   append("cd phonemes; java -cp .. play ", P1, P2),
   name(P3,P2),
   write('Executing: "'), write(P3), write('"'), nl,
   system(P3).

talk :-
   readsentence(S),
   talk(S,P),!,
   play(P).
   


