#!/usr/bin/ruby

require 'cgi'

# Set this to the path of your database file.
$FILE = "/cs/cgi/people/collberg/database.txt"
$FILE = "database.txt"

$cgi =  CGI.new("html3")

###############################################################
# User
###############################################################
class User
   attr_reader :username, :name, :friends, :sex, :password
   attr_writer :username, :name, :friends, :sex, :password

   def initialize(username,name,friends,sex,password)
      # YOUR CODE HERE
   end

   def to_out
      "YOUR CODE HERE"
   end
end

###############################################################
# Database
###############################################################
class Database 

   def initialize 
      # YOUR CODE HERE
   end

   def [] (name) 
      # YOUR CODE HERE
   end

   def []= (name,user) 
      # YOUR CODE HERE
   end

   def users()
      # YOUR CODE HERE
   end

   def exists_user?(name)
      # YOUR CODE HERE
   end

   def load()
       # YOUR CODE HERE
   end

   def save()
       # YOUR CODE HERE
   end
end

###############################################################
#                         Facebook
###############################################################
class Facebook

# The database itself.
@@db = nil

# body is the HTML that you want to transfer to the user.
def Facebook.writeHTML(body)
   $cgi.out { 
     $cgi.html { 
       $cgi.body {
         "\n\n"+body+"\n"
       }
     }
   }
end


################################################################
# Welcome screen
################################################################

def Facebook.welcomeForm()
   return <<-END
   <center><h1>Welcome to 372book</h1></center><br>
   <form target="web.cgi">
      <center> 
         <input type="submit" name="action" value="login">
         <input type="submit" name="action" value="create account">
         <input type="hidden" name="username" value="">
      </center>
   </form>
END
end

def Facebook.welcomeScreen()
   writeHTML(welcomeForm())
end

###############################################################
#                    Login Screen
###############################################################

# This method returns two values, the first one is true
# if login was successful, false otherwise. The second 
# argument is an error message useful when the login was
# unsuccessful. (Yes, using exceptions might be better,
# but I hate exceptions.)
# Error messages returned: 
#    "cannot log in #{username}: no such user"
#    "cannot log in #{username}: wrong password"
def Facebook.login(username,password)
   return true,"YOUR CODE HERE"
end

# Return the HTML for the login screen. "message"
# is an error message (in case the user has made
# an unsuccessful login attempt). Leave it blank
# the first time.
def Facebook.loginForm(message)
   return <<-END
   <center>
       <h1>Log in to 372book</h1><br>
       <font color="red">#{message}</font><br>
       <form target="web.cgi">
          username: <input type="text" name="username"><br>
          password: <input type="password" name="password"><br>
          <input type="submit" name="action" value="login">
          <input type="hidden" name="username" value="">
   </form>
   </center>
END
end

def Facebook.loginScreen()
   username =  $cgi["username"]
   password =  $cgi["password"]
   if username != "" then
      Facebook.load()
      ok, message = Facebook.login(username,password)
      if ok then
         Facebook.profileScreen(username)
      else
         writeHTML(loginForm(message))
      end
   else 
      writeHTML(loginForm(""))
   end
end

################################################################
#                        Logout form
################################################################

def Facebook.logoutScreen()
   writeHTML(welcomeForm())
end

################################################################
#                 Create new user screen
################################################################

# A username consists of a letter (upper or lower case)
# followed by at least one or more letters or digits.
def Facebook.okUsername(un)
   # YOUR CODE HERE
end

# A password consists of four or moour letters or digits.
def Facebook.okPassword(pw)
   # YOUR CODE HERE
end

# Sex is one of Male or Female.
def Facebook.okSex(sex)
   # YOUR CODE HERE
end

# user is an object of type User, containing all the 
# information gathered about the new user. We return
# two values, a boolean which is true if the
# user has been successfully added to the Database
# and false otherwise. On a failed attempt, one of
# these error messages is generated:
#    "cannot create #{username}: user already exists"
#    "cannot create #{username}: illegal username"
#    "cannot create #{username}: illegal password"
#    "cannot create #{username}: choose Male or Female"
def Facebook.createUser(user)
   username = user.username()
   if @@db.exists_user?(username) then
      # YOUR CODE HERE
   end
end


# Return the HTML for the create user screen. "message"
# is an error message. Leave it blank the first time.
def Facebook.createForm(message)
   return <<-END
   <center>
       <h1>Create new account</h1><br>
       <font color="red">#{message}</font><br>
       <form target="web.cgi">
          username: <input type="text" name="username"> <br>
          name: <input type="text" name="realname"> <br>
          password: <input type="password" name="password"> <br>
          sex: <input type="radio" name="sex" value="Male"> Male
               <input type="radio" name="sex" value="Female"> Female <br>
         <input type="submit" name="action" value="save account">
         <input type="hidden" name="username" value="">
   </form>
END
end

# This is where we arrive the first time the user hits the
# create account button:
def Facebook.createScreen()
   writeHTML(createForm(""))
end

# After the user has filled in data into the account screen
# and hits "create account", we'll arrive here. We check
# for valid data and either go to the profile screen (if
# all was OK) or back to the create account screen if there
# was an error.
def Facebook.saveCreatedUser()
   username =  $cgi["username"]
   password =  $cgi["password"]
   realname =  $cgi["realname"]
   sex      =  $cgi["sex"]
   # YOUR CODE HERE
end

################################################################
# User profile page
################################################################

# Do a breadth first search of the friend graph. queue holds
# a list of usernames which we have yet to process. visited
# is a hashtable from usernames to the lever where they were
# first found. The routine returns 'counts', an array where
# count[0] is the number of users at that level from the
# current user (always 0), count[1] is the user's number of
# direct friends, count[2] is the number of friends 2 steps
# away, etc.
def Facebook.BFS(queue, visited, counts, currentlevel)
   # YOUR CODE HERE
   return counts
end

# This routine returns 'counts', an array where
# count[0] is the number of users at that level from the
# current user (always 0), count[1] is the user's number of
# direct friends, count[2] is the number of friends 2 steps
# away, etc.
def Facebook.levels(username)
   counts = [1]
   visited = {username=>0}
   queue = [username]
   # YOUR CODE HERE
end

# On the profile page we list all the user's friends,
# along with a button they can press to go to that
# person's profile page. This routine returns the
# corresponding HTML. 'friend' is the user name of
# the friend, 'how' is how we know that friend.
def Facebook.viewFriendEntry(friend,how)
   return "YOUR CODE HERE"
end

# Return the HTML for a user.
def Facebook.profileForm(username)
   counts = Facebook.levels(username)
   form = <<-END
   <center><h1>Profile for #{username}</h1></center><br> 
   <form target="web.cgi">
   YOUR CODE HERE
   <center>
      <input type="submit" name="action" value="home"> 
      <input type="submit" name="action" value="edit"> 
      <input type="submit" name="action" value="logout">
      <input type="hidden" name="username" value="#{$username}">
  </center>
   </form>
END
end

def Facebook.profileScreen(username)
   Facebook.load()
   writeHTML(profileForm(username))
end

################################################################
#                        View friend form
################################################################


def Facebook.viewFriendScreen(friend)
   Facebook.load()
   writeHTML(profileForm(friend))
end

################################################################
#                      Edit page
################################################################

# Return the HTML for the user's edit page.
def Facebook.editForm(username)
   form = <<-END
   <center><h1>Edit your profile information </h1></center><br>
   <form target="web.cgi">
   YOUR CODE HERE
   <br>
   <center>
      <input type="submit" name="action" value="save edits">
      <input type="submit" name="action" value="home">
      <input type="submit" name="action" value="logout">
      <input type="hidden" name="username" value="#{$username}">
   </center>
END
end

# When the user first hits the EDIT-button, we land here.
def Facebook.editScreen()
   Facebook.load()
   writeHTML(editForm($username))
end

# When he hits the SAVE EDITS-button, we land here.
# Save the edits in the database, write the database
# file back out again, and return the user's profile
# page.
def Facebook.saveEdits()
   Facebook.load()
   name = $cgi['name']
   password = $cgi['password']
   sex = $cgi['sex']
   friends = {}
   # YOUR CODE HERE
end

################################################################
#                  Database load and store
################################################################

def Facebook.load()
  @@db = Database.new
  @@db.load()
  return true, "database loaded"
end

def Facebook.save()
  @@db.save()
  return true, "database saved"
end

end


################################################################
# Main section
################################################################


action = $cgi["action"]
$username = $cgi['username']
#STDERR.puts "ACTION="+action + " username=" + $username
case action
   when ""               then Facebook.welcomeScreen()
   when "login"          then Facebook.loginScreen()
   when "logout"         then Facebook.logoutScreen()
   when "create account" then Facebook.createScreen()
   when "save account"   then Facebook.saveCreatedUser()
   when "edit"           then Facebook.editScreen()
   when "save edits"     then Facebook.saveEdits()
   when "home"           then Facebook.profileScreen($username)
   when /^view [a-zA-Z0-9]+$/         then Facebook.viewFriendScreen($cgi["action"].scan(/[a-zA-Z0-9]+$/)[0])
end
