package ast;
public class ACTUAL extends AST {
   EXPRESSION expr;       // Child
   ACTUAL nextActual;     // Child

   public ACTUAL (int position) {
       this.position = position;
   }

   public ACTUAL (EXPRESSION expr, ACTUAL nextActual, int position) {
       this.expr = expr;
       this.nextActual = nextActual;
       this.position = position;
   }

   public String toString(int indent) {
       String s = blanks(indent) + 
                  "<ACTUAL " + 
                  "pos=\"" + position + "\">\n";
       s += expr.toString(indent+1);
       s += nextActual.toString(indent+1);
       s += blanks(indent) + "</ACTUAL>\n";
       return s;
   }
}
