package ast;
public class ASSIGN extends STATEMENT {
   DESIGNATOR left;           // Child
   EXPRESSION right;          // Child

   public ASSIGN (DESIGNATOR left, EXPRESSION right, int position) {
       this.left = left;
       this.right = right;
       this.position = position;
   }

   public String toString(int indent) {
       String s = blanks(indent) + 
                  "<ASSIGN " + 
                  "pos=\"" + position + "\">\n";
       s += left.toString(indent+1);
       s += right.toString(indent+1);
       s += blanks(indent) + "</ASSIGN>\n";
       return s;
   }
}

