package ast;
public class BINARY extends EXPRESSION {
   int op;             // Input Attribute
   EXPRESSION left;    // Child
   EXPRESSION right;   // Child

   public BINARY (int op, EXPRESSION left, EXPRESSION right, int position) {
       this.op = op;
       this.left = left;
       this.right = right;
       this.position = position;
   }

   public String toString(int indent) {
       String s = blanks(indent) + 
                  "<BINARY op=\"" + 
                  lexer.Token.token2string(op) + 
                  "\" pos=\"" + 
                  position + "\">\n";
       s += left.toString(indent+1);
       s += right.toString(indent+1);
       s += blanks(indent) + "</BINARY>\n";
       return s;
   }
}

