package ast;
public class CONSTDECL extends DECLARATION {
   String typeName;       // Input Attribute
   EXPRESSION expr;           // Child, the value of the constant

   public CONSTDECL (String name, String type, EXPRESSION expr, int position) {
       this.ident = name;
       this.typeName = type;
       this.expr = expr;
       this.position = position;
   }

   public String toString(int indent) {
       String s = blanks(indent) + 
                  "<CONSTDECL " + 
                  "ident=\"" + ident + "\" " +
                  "type=\"" + typeName + "\" " +
                  "pos=\"" + position + "\">\n";
       s += expr.toString(indent+1);
       s += blanks(indent) + "</CONSTDECL>\n";
       return s;
   }
}

