package ast;
public class DECLS extends AST {
   public DECLARATION left;           // Child
   public DECLS right;          // Child

   public DECLS (DECLARATION left, DECLS right, int position) {
       this.left = left;
       this.right = right;
       this.position = position;
   }

   public DECLS (int position) {
       this.position = position;
   }

   public String toString(int indent) {
       String s = blanks(indent) + 
                  "<DECLS " + 
                  "pos=\"" + position + "\">\n";
       s += left.toString(indent+1);
       s += right.toString(indent+1);
       s += blanks(indent) + "</DECLS>\n";
       return s;
   }
}

