package ast;
public class PROGRAM extends DECLARATION {
   String name;
   DECLS decls;          // Child
   STATS stats;          // Child

   public PROGRAM (String name, DECLS decls, STATS stats, int position) {
       this.name = name;
       this.decls = decls;
       this.stats = stats;
       this.position = position;
   }

   public String toString(int indent) {
       String s = blanks(indent) + 
                  "<PROGRAM " + 
                  "name=\"" + name + "\" " +
                  "pos=\"" + position + "\">\n";
       s += decls.toString(indent+1);
       s += stats.toString(indent+1);
       s += blanks(indent) + "</PROGRAM>\n";
       return s;
   }
}

