package ast;
public class REPEAT extends STATEMENT {
   EXPRESSION expr;           // Child
   STATS stats;          // Child

   public REPEAT (EXPRESSION expr, STATS stats, int position) {
       this.expr = expr;
       this.stats = stats;
       this.position = position;
   }

   public String toString(int indent) {
       String s = blanks(indent) + 
                  "<REPEAT " + 
                  "pos=\"" + position + "\">\n";
       s += expr.toString(indent+1);
       s += stats.toString(indent+1);
       s += blanks(indent) + "</REPEAT>\n";
       return s;
   }
}

