package ast;
public class STATS extends AST {
   STATEMENT left;           // Child
   STATS right;          // Child

   public STATS (int position) {
       this.position = position;
   }

   public STATS (STATEMENT left, STATS right, int position) {
       this.left = left;
       this.right = right;
       this.position = position;
   }

   public String toString(int indent) {
       String s = blanks(indent) + 
                  "<STATS " + 
                  "pos=\"" + position + "\">\n";
       s += left.toString(indent+1);
       s += right.toString(indent+1);
       s += blanks(indent) + "</STATS>\n";
       return s;
   }
}

