package ast;
public class UNARY extends EXPRESSION {
   int op;             // Input Attribute
   EXPRESSION left;    // Child

   public UNARY (int op, EXPRESSION left, int position) {
       this.op = op;
       this.left = left;
       this.position = position;
   }

   public UNARY (int position) {
       this.position = position;
   }

   public String toString(int indent) {
       String s = blanks(indent) + 
                  "<UNARY op=\"" + 
                  lexer.Token.token2string(op) + 
                  "\" pos=\"" + 
                  position + "\">\n";
       s += left.toString(indent+1);
       s += blanks(indent) + "</UNARY>\n";
       return s;
   }
}

